/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.mdsofa.common.helper.StringHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.platform.sirius.ui.actions.CreateCECategoriesController;
import org.polarsys.capella.core.platform.sirius.ui.actions.CreateFECategoriesController;
import org.polarsys.capella.core.platform.sirius.ui.actions.CreatePLCategoriesController;

public abstract class CreateCategoriesController {
    Logger _logger = ReportManagerRegistry.getInstance().subscribe("Model Management");

    public static CreateCategoriesController createCreateCategoriesController(List<EObject> selection) {
        if (selection.isEmpty()) {
            return null;
        }
        EObject first = selection.get(0);
        if (first instanceof FunctionalExchange) {
            return new CreateFECategoriesController();
        }
        if (first instanceof ComponentExchange) {
            return new CreateCECategoriesController();
        }
        if (first instanceof PhysicalLink) {
            return new CreatePLCategoriesController();
        }
        return null;
    }

    public void createAndAttachCategory(List<EObject> selection) {
        if (selection.isEmpty()) {
            return;
        }
    }

    protected EObject createCategory(EObject container) {
        return null;
    }

    protected boolean isNullOrNotInstanceOf(EObject elt, List<EClass> eClasses) {
        boolean result = false;
        if (elt == null) {
            result = true;
        } else if (eClasses.isEmpty()) {
            result = false;
        } else {
            for (EClass eClass : eClasses) {
                if (!eClass.isInstance((Object)elt)) continue;
                result = false;
                return result;
            }
            result = true;
        }
        return result;
    }

    protected EObject getBestContainerForCategory(List<EObject> selection, List<EClass> expectedContainerType) {
        EObject commonAncestor = EcoreUtil2.getCommonAncestor(selection);
        EObject container = EObjectExt.isInstanceOf((EObject)commonAncestor, expectedContainerType) ? commonAncestor : EcoreUtil2.getFirstContainer((EObject)commonAncestor, expectedContainerType);
        if (container == null) {
            BlockArchitecture currentArch = BlockArchitectureExt.getRootBlockArchitecture((EObject)selection.get(0));
            container = BlockArchitectureExt.getContext((BlockArchitecture)currentArch, (boolean)false);
        }
        return container;
    }

    protected void logResults(String message, NamedElement category) {
        this._logger.info((Object)new EmbeddedMessage(StringHelper.formatMessage((String)message, (Object[])new String[]{category.getName()}), "Model Management", (Object)category));
    }
}

