/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.business.queries.fa.ComponentExchange_Categories;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.actions.UpdateCategoriesController;

public class UpdateCECategoriesController
extends UpdateCategoriesController {
    @Override
    public void updateCategories(List<EObject> selectedElements, List<EObject> categoriesToAdd, List<EObject> categoriesToRemove) {
        for (EObject e : selectedElements) {
            if (!(e instanceof ComponentExchange)) continue;
            EList categories = ((ComponentExchange)e).getCategories();
            categories.addAll(categoriesToAdd);
            categories.removeAll(categoriesToRemove);
        }
        if (!selectedElements.isEmpty() && selectedElements.get(0) instanceof CommunicationMean) {
            this.logResults(Messages.UpdateCMCategories_add_msg, categoriesToAdd);
            this.logResults(Messages.UpdateCMCategories_remove_msg, categoriesToRemove);
        } else {
            this.logResults(Messages.UpdateCECategories_add_msg, categoriesToAdd);
            this.logResults(Messages.UpdateCECategories_remove_msg, categoriesToRemove);
        }
    }

    @Override
    public List<EObject> getAvailableCategories(List<EObject> element) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject fe : element) {
            if (!(fe instanceof ComponentExchange)) continue;
            List categories = new ComponentExchange_Categories().getAvailableElements((EObject)((ComponentExchange)fe));
            result.addAll(categories);
        }
        return result;
    }

    @Override
    public List<EObject> getCommonCategories(List<EObject> selection) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (selection.isEmpty()) {
            return result;
        }
        EObject first = selection.get(0);
        if (first instanceof ComponentExchange) {
            result.addAll((Collection<EObject>)((ComponentExchange)first).getCategories());
        }
        for (EObject eObject : selection) {
            if (!(eObject instanceof ComponentExchange)) continue;
            result.retainAll((Collection<?>)((ComponentExchange)eObject).getCategories());
        }
        return result;
    }
}

