/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.refresh.RefreshDiagramAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.ui.actions.AbstractTigAction;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.actions.UpdateCategoriesController;
import org.polarsys.capella.core.platform.sirius.ui.actions.WizardActionHelper;
import org.polarsys.capella.core.ui.toolkit.helpers.SelectionDialogHelper;

public class UpdateCategoriesWizardAction
extends AbstractTigAction
implements IHandler {
    private UpdateCategoriesController _updateCatController;

    public void run(IAction action) {
        final List<EObject> selection = WizardActionHelper.converToEObjectList(this.getSelectedElements());
        if (selection.isEmpty()) {
            return;
        }
        if (UpdateCategoriesController.isValidSelection(selection)) {
            this._updateCatController = UpdateCategoriesController.createUpdateCategoriesController(selection);
            List<EObject> availableElements = this._updateCatController.getAvailableCategories(selection);
            List<EObject> commonCategories = this._updateCatController.getCommonCategories(selection);
            List wizardSelections = SelectionDialogHelper.multiplePropertyTransfertDialogWizard((Shell)this.getActiveShell(), (String)Messages.UpdateCategoriesWizardAction_Title, (String)Messages.UpdateCategoriesWizardAction_msg, availableElements, commonCategories);
            if (wizardSelections != null) {
                final ArrayList<EObject> catToRemove = new ArrayList<EObject>();
                catToRemove.addAll(commonCategories);
                catToRemove.removeAll(wizardSelections);
                final ArrayList catToAdd = new ArrayList();
                catToAdd.addAll(wizardSelections);
                catToAdd.removeAll(commonCategories);
                AbstractReadWriteCommand performedChangesCommand = new AbstractReadWriteCommand(){

                    public String getName() {
                        return Messages.AllocationManagementWizardAction_Command_Label;
                    }

                    public void run() {
                        UpdateCategoriesWizardAction.this.handleChanges(selection, catToAdd, catToRemove);
                    }
                };
                this.getExecutionManager().execute((ICommand)performedChangesCommand);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelection diagramSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
                        RefreshDiagramAction.refresh((ISelection)diagramSelection);
                    }
                });
            }
        } else {
            WizardActionHelper.createMessageBox(this.getActiveShell(), Messages.AllocationManagementWizardAction_Warning_Message, 2);
        }
    }

    protected void handleChanges(List<EObject> selectedElements, List<EObject> categoriesToAdd, List<EObject> categoriesToRemove) {
        this._updateCatController.updateCategories(selectedElements, categoriesToAdd, categoriesToRemove);
    }
}

