/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.business.queries.fa.FunctionalExchange_Categories;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.actions.UpdateCategoriesController;

public class UpdateFECategoriesController
extends UpdateCategoriesController {
    public static final String MESSAGE = "Update functional exchange categories";

    @Override
    public void updateCategories(List<EObject> selectedElements, List<EObject> categoriesToAdd, List<EObject> categoriesToRemove) {
        for (EObject e : selectedElements) {
            if (!(e instanceof FunctionalExchange)) continue;
            EList categories = ((FunctionalExchange)e).getCategories();
            categories.addAll(categoriesToAdd);
            categories.removeAll(categoriesToRemove);
        }
        this.logResults(Messages.UpdateFECategories_add_msg, categoriesToAdd);
        this.logResults(Messages.UpdateFECategories_remove_msg, categoriesToRemove);
    }

    @Override
    public List<EObject> getAvailableCategories(List<EObject> element) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject fe : element) {
            if (!(fe instanceof FunctionalExchange)) continue;
            List feCategories = new FunctionalExchange_Categories().getAvailableElements((EObject)((FunctionalExchange)fe));
            result.addAll(feCategories);
        }
        return result;
    }

    @Override
    public List<EObject> getCommonCategories(List<EObject> selection) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (selection.isEmpty()) {
            return result;
        }
        EObject first = selection.get(0);
        if (first instanceof FunctionalExchange) {
            result.addAll((Collection<EObject>)((FunctionalExchange)first).getCategories());
        }
        for (EObject eObject : selection) {
            if (!(eObject instanceof FunctionalExchange)) continue;
            result.retainAll((Collection<?>)((FunctionalExchange)eObject).getCategories());
        }
        return result;
    }
}

