/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.business.queries.cs.PhysicalLink_Categories;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.actions.UpdateCategoriesController;

public class UpdatePLCategoriesController
extends UpdateCategoriesController {
    @Override
    public void updateCategories(List<EObject> selectedElements, List<EObject> categoriesToAdd, List<EObject> categoriesToRemove) {
        for (EObject e : selectedElements) {
            if (!(e instanceof PhysicalLink)) continue;
            EList categories = ((PhysicalLink)e).getCategories();
            categories.addAll(categoriesToAdd);
            categories.removeAll(categoriesToRemove);
        }
        this.logResults(Messages.UpdatePLCategories_add_msg, categoriesToAdd);
        this.logResults(Messages.UpdatePLCategories_remove_msg, categoriesToRemove);
    }

    @Override
    public List<EObject> getAvailableCategories(List<EObject> element) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject e : element) {
            if (!(e instanceof PhysicalLink)) continue;
            List categories = new PhysicalLink_Categories().getAvailableElements((EObject)((PhysicalLink)e));
            result.addAll(categories);
        }
        return result;
    }

    @Override
    public List<EObject> getCommonCategories(List<EObject> selection) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (selection.isEmpty()) {
            return result;
        }
        EObject first = selection.get(0);
        if (first instanceof PhysicalLink) {
            result.addAll((Collection<EObject>)((PhysicalLink)first).getCategories());
        }
        for (EObject eObject : selection) {
            if (!(eObject instanceof PhysicalLink)) continue;
            result.retainAll((Collection<?>)((PhysicalLink)eObject).getCategories());
        }
        return result;
    }
}

