/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;

public abstract class AbstractFixCommand
extends AbstractReadWriteCommand {
    protected Collection<ModelElement> _selection = null;
    private IProgressMonitor _progressMonitor = null;

    public AbstractFixCommand(Collection<ModelElement> selection) {
        this(selection, (IProgressMonitor)new NullProgressMonitor());
    }

    public AbstractFixCommand(Collection<ModelElement> selection, IProgressMonitor progressMonitor) {
        this._selection = selection;
        this._progressMonitor = progressMonitor;
    }

    protected Collection<ModelElement> retrieveModelElements(ModelElement modelElement) {
        return Collections.singleton(modelElement);
    }

    public void run() {
        LongRunningListenersRegistry.getInstance().operationStarting(((Object)((Object)this)).getClass());
        try {
            for (ModelElement selectedElement : this._selection) {
                Collection<ModelElement> elements = this.retrieveModelElements(selectedElement);
                this._progressMonitor.beginTask(this.getName(), elements.size());
                for (ModelElement element : elements) {
                    this.process(element);
                    this._progressMonitor.worked(1);
                }
            }
        }
        finally {
            LongRunningListenersRegistry.getInstance().operationEnded(((Object)((Object)this)).getClass());
        }
    }

    protected abstract void process(ModelElement var1);
}

