/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractRelationship;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.StateEvent;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.cs.AbstractPathInvolvedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkCategory;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocator;
import org.polarsys.capella.core.data.fa.ComponentExchangeCategory;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeRealization;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchangeRealization;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.model.handler.command.IDeleteHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.PhysicalLinkExt;
import org.polarsys.capella.core.model.helpers.PhysicalPathExt;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;
import org.polarsys.capella.core.platform.sirius.ui.preferences.IDeletePreferences;

public class DeleteHelper
implements IDeleteHelper {
    protected void addElementsForAssociation(Set<? super EObject> elementsToDelete) {
        ArrayList elementToAdd = new ArrayList(0);
        for (EObject eObject : elementsToDelete) {
            if (!(eObject instanceof Association)) continue;
            elementToAdd.addAll(((Association)eObject).getNavigableMembers());
        }
        if (!elementToAdd.isEmpty()) {
            elementsToDelete.addAll(elementToAdd);
        }
    }

    protected void addElementsForFunctionalChainInvolvement(Set<? super EObject> elementsToDelete) {
        ArrayList elementToAdd = new ArrayList(0);
        for (EObject eObject : elementsToDelete) {
            FunctionalChainInvolvement fcInvolvement;
            InvolvedElement involved;
            if (!(eObject instanceof FunctionalChainInvolvement) || (involved = (fcInvolvement = (FunctionalChainInvolvement)eObject).getInvolved()) == null || !(involved instanceof AbstractFunction) && !(involved instanceof FunctionalChain)) continue;
            elementToAdd.addAll(fcInvolvement.getNextFunctionalChainInvolvements());
            elementToAdd.addAll(fcInvolvement.getPreviousFunctionalChainInvolvements());
        }
        if (!elementToAdd.isEmpty()) {
            elementsToDelete.addAll(elementToAdd);
        }
    }

    protected void addElementsForPhysicalPathInvolvement(Set<? super EObject> elementsToDelete) {
        ArrayList elementToAdd = new ArrayList(0);
        for (EObject eObject : elementsToDelete) {
            PhysicalPathInvolvement pathInvolvement;
            AbstractPathInvolvedElement involved;
            if (!(eObject instanceof PhysicalPathInvolvement) || (involved = (pathInvolvement = (PhysicalPathInvolvement)eObject).getInvolvedElement()) == null || !(involved instanceof Part) && !(involved instanceof PhysicalPath)) continue;
            elementToAdd.addAll(pathInvolvement.getNextInvolvements());
            elementToAdd.addAll(pathInvolvement.getPreviousInvolvements());
        }
        if (!elementToAdd.isEmpty()) {
            elementsToDelete.addAll(elementToAdd);
        }
    }

    protected void addElementsForAbstractFunction(Set<? super EObject> elementsToDelete) {
        ArrayList elementsToAdd = new ArrayList();
        for (EObject eObject : elementsToDelete) {
            if (!(eObject instanceof AbstractFunction)) continue;
            elementsToAdd.addAll(EObjectExt.getReferencers((EObject)eObject, (EReference)InteractionPackage.Literals.STATE_FRAGMENT__RELATED_ABSTRACT_FUNCTION));
        }
        elementsToDelete.addAll(elementsToAdd);
    }

    protected void addElementsForAbstractState(Set<? super EObject> elementsToDelete) {
        ArrayList elementsToAdd = new ArrayList();
        for (EObject eObject : elementsToDelete) {
            if (!(eObject instanceof AbstractState)) continue;
            elementsToAdd.addAll(EObjectExt.getReferencers((EObject)eObject, (EReference)InteractionPackage.Literals.STATE_FRAGMENT__RELATED_ABSTRACT_STATE));
        }
        elementsToDelete.addAll(elementsToAdd);
    }

    protected void addPendingPropertyValues(Set<? super EObject> elementsToDelete) {
        HashSet propertyValuesToAddToDeletedElements = new HashSet(0);
        for (EObject eObject : elementsToDelete) {
            if (!(eObject instanceof CapellaElement)) continue;
            EList appliedPropertyValues = ((CapellaElement)eObject).getAppliedPropertyValues();
            for (AbstractPropertyValue propertyValue : appliedPropertyValues) {
                EList valuedElements = propertyValue.getValuedElements();
                if (propertyValue == eObject || !propertyValue.getInvolvedElements().isEmpty() || valuedElements.size() != 1 || !valuedElements.contains(eObject)) continue;
                HashSet<AbstractPropertyValue> propertyValues = new HashSet<AbstractPropertyValue>();
                propertyValues.add(propertyValue);
                this.addPendingPropertyValues(propertyValues);
                propertyValuesToAddToDeletedElements.addAll(propertyValues);
            }
        }
        if (!propertyValuesToAddToDeletedElements.isEmpty()) {
            elementsToDelete.addAll(propertyValuesToAddToDeletedElements);
        }
    }

    protected void addPendingPropertyValueGroups(Set<? super EObject> elementsToDelete) {
        HashSet propertyValueGroupsToAddToDeletedElements = new HashSet(0);
        for (EObject eObject : elementsToDelete) {
            if (!(eObject instanceof CapellaElement)) continue;
            EList appliedPropertyValueGroups = ((CapellaElement)eObject).getAppliedPropertyValueGroups();
            for (PropertyValueGroup propertyValueGroup : appliedPropertyValueGroups) {
                EList valuedElements;
                if (elementsToDelete.contains(propertyValueGroup) || (valuedElements = propertyValueGroup.getValuedElements()).size() != 1 || !valuedElements.contains(eObject)) continue;
                HashSet<PropertyValueGroup> propertyValueGroups = new HashSet<PropertyValueGroup>();
                propertyValueGroups.add(propertyValueGroup);
                this.addPendingPropertyValueGroups(propertyValueGroups);
                propertyValueGroupsToAddToDeletedElements.addAll(propertyValueGroups);
            }
        }
        if (!propertyValueGroupsToAddToDeletedElements.isEmpty()) {
            elementsToDelete.addAll(propertyValueGroupsToAddToDeletedElements);
        }
    }

    protected void getAdditionalElementsForParts(Set<? super AbstractType> elementsToDelete) {
        HashSet<AbstractType> result = new HashSet<AbstractType>(0);
        for (AbstractType abstractType : elementsToDelete) {
            AbstractType type;
            if (!(abstractType instanceof Part) || !this.shouldDeleteTypeOf((Part)abstractType) || (type = ((Part)abstractType).getAbstractType()) == null) continue;
            result.add(type);
        }
        elementsToDelete.addAll(result);
    }

    protected void addElementsForScenario(Collection<Object> elementsToDelete) {
        List<Object> result = Collections.emptyList();
        result = new ArrayList<Object>();
        for (Object object : elementsToDelete) {
            if (object instanceof TimeLapse) {
                TimeLapse exec = (TimeLapse)object;
                result.add(exec.getStart());
                result.add(exec.getFinish());
                if (object instanceof CombinedFragment) {
                    CombinedFragment cf = (CombinedFragment)object;
                    result.addAll((Collection<Object>)cf.getReferencedOperands());
                }
            } else if (object instanceof InstanceRole) {
                result.addAll(EObjectExt.getReferencers((EObject)((EObject)object), (EReference)InteractionPackage.Literals.EXECUTION__COVERED));
                for (EObject fragment : EObjectExt.getReferencers((EObject)((EObject)object), (EReference)InteractionPackage.Literals.INTERACTION_FRAGMENT__COVERED_INSTANCE_ROLES)) {
                    if (((InteractionFragment)fragment).getCoveredInstanceRoles().size() != 1) continue;
                    result.add(fragment);
                }
            } else if (object instanceof SequenceMessage) {
                result.add(((SequenceMessage)object).getSendingEnd());
                result.add(((SequenceMessage)object).getReceivingEnd());
            }
            if (!(object instanceof InteractionFragment)) continue;
            result.addAll(EObjectExt.getReferencers((EObject)((EObject)object), (EReference)InteractionPackage.Literals.TIME_LAPSE__START));
            result.addAll(EObjectExt.getReferencers((EObject)((EObject)object), (EReference)InteractionPackage.Literals.TIME_LAPSE__FINISH));
            if (object instanceof AbstractEnd) {
                result.add(((AbstractEnd)object).getEvent());
            }
            if (object instanceof MessageEnd) {
                result.add(((MessageEnd)object).getMessage());
            }
            result.addAll(EObjectExt.getReferencers((EObject)((EObject)object), (EReference)InteractionPackage.Literals.CONSTRAINT_DURATION__START));
            result.addAll(EObjectExt.getReferencers((EObject)((EObject)object), (EReference)InteractionPackage.Literals.CONSTRAINT_DURATION__FINISH));
        }
        for (Object object : result) {
            if (object == null) continue;
            elementsToDelete.add(object);
        }
    }

    protected boolean shouldDeleteTypeOf(Part deletedPart) {
        boolean allowMultiplePart = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)deletedPart));
        return !allowMultiplePart || IDeletePreferences.INSTANCE.isDeletingPartType();
    }

    public Set<?> getExpandedSelection(Collection<?> selection) {
        HashSet<Object> expandedSelection = new HashSet<Object>(selection);
        this.getAdditionalElementsForParts(expandedSelection);
        this.addElementsForPhysicalPathInvolvement(expandedSelection);
        this.addElementsForAbstractState(expandedSelection);
        this.addElementsForAbstractFunction(expandedSelection);
        this.addElementsForFunctionalChainInvolvement(expandedSelection);
        this.addElementsForAssociation(expandedSelection);
        this.addElementsForScenario(expandedSelection);
        this.addPendingPropertyValues(expandedSelection);
        this.addPendingPropertyValueGroups(expandedSelection);
        if (CapellaModelPreferencesPlugin.getDefault().isSynchronizationOfComponentPortToFunctionPortAllowed()) {
            this.addElementsForComponentExchangeFunctionalExchangeAllocation(expandedSelection);
        }
        if (CapellaModelPreferencesPlugin.getDefault().isSynchronizationOfPhysicalPortToComponentPortOnPhysicalLinkAllowed()) {
            this.addElementsForComponentExchangeAllocationFromPL(expandedSelection);
        }
        if (CapellaModelPreferencesPlugin.getDefault().isSynchronizationOfPhysicalPortToComponentPortOnPhysicalPathAllowed()) {
            this.addElementsForComponentExchangeAllocationFromPP(expandedSelection);
        }
        return expandedSelection;
    }

    protected void addElementsForComponentExchangeAllocationFromPL(Set<? super EObject> elementsToDelete) {
        HashSet<EObject> elementsToAddToDeletion = new HashSet<EObject>();
        for (EObject eObject : elementsToDelete) {
            if (eObject instanceof ComponentExchangeAllocation) {
                ComponentExchange exchange = ((ComponentExchangeAllocation)eObject).getComponentExchangeAllocated();
                ComponentExchangeAllocator allocator = ((ComponentExchangeAllocation)eObject).getComponentExchangeAllocator();
                if (!(allocator instanceof PhysicalLink)) continue;
                elementsToAddToDeletion.addAll(PhysicalLinkExt.evaluateImpactsOfUnsynchronizeAllocations((PhysicalLink)((PhysicalLink)allocator), (ComponentExchange)exchange, (boolean)true));
                continue;
            }
            if (eObject instanceof PhysicalLink) {
                elementsToAddToDeletion.addAll(this.getRelatedElements((PhysicalLink)eObject));
                continue;
            }
            if (!(eObject instanceof PhysicalPort)) continue;
            for (PhysicalLink link : ((PhysicalPort)eObject).getInvolvedLinks()) {
                elementsToAddToDeletion.addAll(this.getRelatedElements(link));
            }
        }
        if (!elementsToAddToDeletion.isEmpty()) {
            elementsToDelete.addAll(elementsToAddToDeletion);
        }
    }

    protected void addElementsForComponentExchangeAllocationFromPP(Set<? super EObject> elementsToDelete) {
        HashSet<EObject> elementsToAddToDeletion = new HashSet<EObject>();
        for (EObject eObject : elementsToDelete) {
            if (eObject instanceof ComponentExchangeAllocation) {
                ComponentExchange exchange = ((ComponentExchangeAllocation)eObject).getComponentExchangeAllocated();
                ComponentExchangeAllocator allocator = ((ComponentExchangeAllocation)eObject).getComponentExchangeAllocator();
                if (!(allocator instanceof PhysicalPath)) continue;
                elementsToAddToDeletion.addAll(PhysicalPathExt.evaluateImpactsOfUnsynchronizeAllocations((PhysicalPath)((PhysicalPath)allocator), (ComponentExchange)exchange, (boolean)true));
                continue;
            }
            if (!(eObject instanceof PhysicalPath)) continue;
            elementsToAddToDeletion.addAll(this.getRelatedElements((PhysicalPath)eObject));
        }
        if (!elementsToAddToDeletion.isEmpty()) {
            elementsToDelete.addAll(elementsToAddToDeletion);
        }
    }

    protected void addElementsForComponentExchangeFunctionalExchangeAllocation(Set<? super EObject> elementsToDelete) {
        HashSet<EObject> elementsToAddToDeletion = new HashSet<EObject>();
        for (EObject eObject : elementsToDelete) {
            if (eObject instanceof ComponentExchangeFunctionalExchangeAllocation) {
                ComponentExchange cptExchange = ((ComponentExchangeFunctionalExchangeAllocation)eObject).getAllocatingComponentExchange();
                FunctionalExchange fctExchange = ((ComponentExchangeFunctionalExchangeAllocation)eObject).getAllocatedFunctionalExchange();
                elementsToAddToDeletion.addAll(ComponentExchangeExt.evaluateImpactsOfUnsynchronizeAllocations((ComponentExchange)cptExchange, (FunctionalExchange)fctExchange, (boolean)true));
                continue;
            }
            if (eObject instanceof ComponentExchange) {
                elementsToAddToDeletion.addAll(this.getRelatedElements((ComponentExchange)eObject));
                continue;
            }
            if (!(eObject instanceof ComponentPort)) continue;
            for (ComponentExchange exchange : ((ComponentPort)eObject).getComponentExchanges()) {
                elementsToAddToDeletion.addAll(this.getRelatedElements(exchange));
            }
        }
        if (!elementsToAddToDeletion.isEmpty()) {
            elementsToDelete.addAll(elementsToAddToDeletion);
        }
    }

    private Set<EObject> getRelatedElements(PhysicalLink link) {
        HashSet<EObject> elementsToAddToDeletion = new HashSet<EObject>();
        for (ComponentExchangeAllocation allocation : link.getOwnedComponentExchangeAllocations()) {
            ComponentExchange cpntExch = allocation.getComponentExchangeAllocated();
            elementsToAddToDeletion.addAll(PhysicalLinkExt.evaluateImpactsOfUnsynchronizeAllocations((PhysicalLink)link, (ComponentExchange)cpntExch, (boolean)true));
        }
        return elementsToAddToDeletion;
    }

    private Set<EObject> getRelatedElements(PhysicalPath path) {
        HashSet<EObject> elementsToAddToDeletion = new HashSet<EObject>();
        for (ComponentExchangeAllocation allocation : path.getOwnedComponentExchangeAllocations()) {
            ComponentExchange cpntExch = allocation.getComponentExchangeAllocated();
            elementsToAddToDeletion.addAll(PhysicalPathExt.evaluateImpactsOfUnsynchronizeAllocations((PhysicalPath)path, (ComponentExchange)cpntExch, (boolean)true));
        }
        return elementsToAddToDeletion;
    }

    private Set<EObject> getRelatedElements(ComponentExchange exchange) {
        HashSet<EObject> elementsToAddToDeletion = new HashSet<EObject>();
        for (ComponentExchangeFunctionalExchangeAllocation allocation : exchange.getOwnedComponentExchangeFunctionalExchangeAllocations()) {
            FunctionalExchange fctExchange = allocation.getAllocatedFunctionalExchange();
            elementsToAddToDeletion.addAll(ComponentExchangeExt.evaluateImpactsOfUnsynchronizeAllocations((ComponentExchange)exchange, (FunctionalExchange)fctExchange, (boolean)true));
            for (PhysicalLink link : exchange.getAllocatorPhysicalLinks()) {
                elementsToAddToDeletion.addAll(PhysicalLinkExt.evaluateImpactsOfUnsynchronizeAllocations((PhysicalLink)link, (ComponentExchange)exchange, (boolean)true));
            }
        }
        return elementsToAddToDeletion;
    }

    public boolean isDeleteSemanticStructure(EObject sourceObject, EObject linkObject, EStructuralFeature feature) {
        if (CapellacorePackage.Literals.CAPELLA_ELEMENT__APPLIED_PROPERTY_VALUE_GROUPS.equals(feature) || CapellacorePackage.Literals.CAPELLA_ELEMENT__APPLIED_PROPERTY_VALUES.equals(feature)) {
            return false;
        }
        return sourceObject instanceof AbstractRelationship ? this.isDeletableLink((AbstractRelationship)sourceObject, linkObject, feature) : this.isPendingElement(sourceObject, linkObject, feature);
    }

    public boolean isDeleteElement(EObject sourceObject, EObject linkObject, EStructuralFeature feature) {
        return sourceObject instanceof AbstractTrace && this.isDeletableTrace((AbstractTrace)sourceObject, linkObject, feature);
    }

    protected boolean isDeletableAssociation(Association association, EObject member) {
        EList ownedMembers = association.getOwnedMembers();
        return 2 >= ownedMembers.size() && ownedMembers.contains((Object)member);
    }

    protected boolean isDeletableLink(AbstractRelationship link, EObject linkedObject, EStructuralFeature feature) {
        boolean result = true;
        boolean testTraceFeature = false;
        if (linkedObject instanceof PropertyValueGroup) {
            result = false;
        } else if (link instanceof FunctionalExchange) {
            if (linkedObject instanceof AbstractEventOperation || linkedObject instanceof ExchangeItem || linkedObject instanceof FunctionalChainInvolvement || linkedObject instanceof ExchangeCategory || linkedObject instanceof PhysicalLink) {
                result = false;
            } else {
                testTraceFeature = linkedObject instanceof FunctionalExchangeRealization || linkedObject instanceof ComponentExchangeFunctionalExchangeAllocation;
            }
        } else if (linkedObject instanceof AbstractFunction || linkedObject instanceof StateEvent) {
            if (CapellacommonPackage.Literals.STATE_TRANSITION__EFFECT.equals(feature)) {
                return false;
            }
            if (CapellacommonPackage.Literals.STATE_TRANSITION__TRIGGERS.equals(feature)) {
                return false;
            }
        } else if (link instanceof ComponentExchange) {
            if (linkedObject instanceof AbstractEventOperation || linkedObject instanceof ExchangeItem || linkedObject instanceof ComponentExchangeCategory) {
                result = false;
            } else {
                testTraceFeature = linkedObject instanceof ComponentExchangeRealization || linkedObject instanceof ComponentExchangeFunctionalExchangeAllocation || linkedObject instanceof ComponentExchangeAllocation;
            }
        } else if (link instanceof FunctionalChainInvolvement) {
            if (FaPackage.Literals.FUNCTIONAL_CHAIN_INVOLVEMENT__EXCHANGED_ITEMS.equals(feature)) {
                return false;
            }
            InvolvedElement involved = ((Involvement)link).getInvolved();
            result = involved == null || involved instanceof FunctionalExchange;
        } else if (link instanceof PhysicalPathInvolvement) {
            AbstractPathInvolvedElement involved = ((PhysicalPathInvolvement)link).getInvolvedElement();
            result = involved == null || involved instanceof PhysicalLink;
        } else if (linkedObject instanceof TransfoLink) {
            testTraceFeature = true;
        }
        if (testTraceFeature) {
            boolean bl = result = !ModellingcorePackage.Literals.TRACEABLE_ELEMENT__INCOMING_TRACES.equals(feature) && !ModellingcorePackage.Literals.TRACEABLE_ELEMENT__OUTGOING_TRACES.equals(feature);
        }
        if (CapellacommonPackage.Literals.STATE_TRANSITION__GUARD.equals(feature)) {
            result = false;
        }
        return result;
    }

    protected boolean isDeletableTrace(AbstractTrace trace, EObject referencingElement, EStructuralFeature referencingFeature) {
        boolean result = true;
        if (referencingElement instanceof TransfoLink && (ModellingcorePackage.Literals.TRACEABLE_ELEMENT__INCOMING_TRACES.equals(referencingFeature) || ModellingcorePackage.Literals.TRACEABLE_ELEMENT__OUTGOING_TRACES.equals(referencingFeature))) {
            result = false;
        }
        return result;
    }

    protected boolean isPendingElement(EObject sourceObject, EObject linkedObject, EStructuralFeature feature) {
        boolean result = false;
        if (sourceObject instanceof Part) {
            boolean shouldDelete = !CapellaProjectHelper.TriStateBoolean.False.equals((Object)CapellaProjectHelper.isSingletonComponentsDriven((EObject)sourceObject)) || IDeletePreferences.INSTANCE.isDeletingPartType();
            result = shouldDelete && linkedObject instanceof Component && ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE.equals(feature);
        } else if (sourceObject instanceof PropertyValueGroup) {
            result = this.isPendingPropertyValueGroup((PropertyValueGroup)sourceObject, linkedObject, feature);
        } else if (sourceObject instanceof ComponentExchangeEnd) {
            result = true;
        } else if (linkedObject instanceof ExchangeItem) {
            result = sourceObject instanceof CommunicationLink;
        } else if (sourceObject instanceof PhysicalLink) {
            result = !(linkedObject instanceof PhysicalLinkCategory);
        } else if (sourceObject instanceof PhysicalLinkEnd) {
            result = true;
        }
        return result;
    }

    protected boolean isPendingPropertyValueGroup(PropertyValueGroup group, EObject referencingElement, EStructuralFeature feature) {
        HashSet storedValuedElements = new HashSet(group.getValuedElements());
        storedValuedElements.addAll(group.getAppliedPropertyValueGroups());
        storedValuedElements.remove(referencingElement);
        return storedValuedElements.isEmpty();
    }

    public Collection<EObject> getAdditionalElements(EObject sourceObject, EObject linkObject, EStructuralFeature feature) {
        EObject container;
        if (sourceObject instanceof Property && (container = sourceObject.eContainer()) instanceof Association && this.isDeletableAssociation((Association)container, sourceObject)) {
            return Collections.singleton(container);
        }
        return Collections.emptyList();
    }

    public Collection<Command> getAdditionalCommands(EObject sourceObject, EObject linkObject, EStructuralFeature feature) {
        return null;
    }

    @Deprecated
    protected Collection<? extends EObject> getAllObjectsFromAbstractEnd(InteractionFragment interactionFragment) {
        return Collections.emptyList();
    }

    @Deprecated
    protected Collection<? extends EObject> getExecutionFromScenarioElement(Collection<?> elementsToDelete) {
        return Collections.emptyList();
    }

    @Deprecated
    protected void globalizeElementsForScenario(Set<? super EObject> elementsToDelete) {
    }

    @Deprecated
    protected boolean isSequenceDiagramObject(Object elementsToDelete) {
        return false;
    }

    @Deprecated
    protected List<? extends EObject> propagageSequenceDeletion(TimeLapse exec) {
        return Collections.emptyList();
    }
}

