/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IEditorPart;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.Messages;

public class DeleteRepresentationCommand
extends RecordingCommand {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private Collection<DRepresentation> _representations;
    private IProgressMonitor _monitor;

    public DeleteRepresentationCommand(TransactionalEditingDomain domain, Collection<DRepresentation> representations) {
        this(domain, representations, (IProgressMonitor)new NullProgressMonitor());
    }

    public DeleteRepresentationCommand(TransactionalEditingDomain domain, Collection<DRepresentation> representations, IProgressMonitor monitor) {
        super(domain, Messages.DeleteRepresentationCommand_DeleteRepresentationCommandLabel);
        this._representations = representations;
        this._monitor = monitor;
    }

    protected void doExecute() {
        if (this._representations == null || this._representations.size() == 0) {
            return;
        }
        try {
            this._monitor.beginTask(this.description, this._representations.size());
            for (DRepresentation representation : this._representations) {
                DSemanticDecorator semanticDecorator = (DSemanticDecorator)representation;
                if (representation.getName() != null) {
                    this._monitor.setTaskName(NLS.bind((String)Messages.DeleteRepresentationCommand_DeleteRepresentationCommandText, (Object)representation.getName()));
                }
                Session session = null;
                EObject targetElement = semanticDecorator.getTarget();
                if (targetElement != null) {
                    session = SessionManager.INSTANCE.getSession(targetElement);
                }
                if (session == null) {
                    session = this.getSession(semanticDecorator.eResource());
                }
                if (session != null) {
                    this.closeActiveRepresentationEditor(representation, session);
                    DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((Session)session, (DRepresentation)representation);
                    if (descriptor != null && DialectManager.INSTANCE.deleteRepresentation(descriptor, session)) {
                        SessionManager.INSTANCE.notifyRepresentationDeleted(session);
                    }
                } else {
                    StringBuilder loggerMessage = new StringBuilder("DeleteRepresentationAction.DeleteRepresentationCommand.doExecute(..) _ ");
                    loggerMessage.append("unable to find a session for ").append(semanticDecorator.toString());
                    __logger.error((Object)new EmbeddedMessage(loggerMessage.toString(), "User Interface"));
                }
                this._monitor.worked(1);
            }
        }
        finally {
            this._monitor.done();
        }
    }

    private void closeActiveRepresentationEditor(DRepresentation representation, Session session) {
        IEditingSession editingSession = SessionUIManager.INSTANCE.getUISession(session);
        if (editingSession == null) {
            return;
        }
        DialectEditor editor = editingSession.getEditor(representation);
        if (editor != null) {
            DialectUIManager.INSTANCE.closeEditor((IEditorPart)editor, false);
            editingSession.detachEditor(editor);
        }
    }

    private Session getSession(Resource airdResource) {
        Session result = null;
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            HashSet<Resource> allAnalysisResources = new HashSet<Resource>(session.getReferencedSessionResources());
            allAnalysisResources.add(session.getSessionResource());
            if (!allAnalysisResources.contains(airdResource)) continue;
            result = session;
            break;
        }
        return result;
    }
}

