/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.interface_;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.validation.interface_.Messages;
import org.polarsys.capella.core.data.helpers.information.services.LinkCompatibilityDefinition;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class ExchangeItemAllocationProtocolSequence
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ExchangeItemAllocation && ((ExchangeItemAllocation)eObj).getAllocatedItem() != null) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            ExchangeItemAllocation allocation = (ExchangeItemAllocation)eObj;
            ExchangeMechanism mechanism = allocation.getAllocatedItem().getExchangeMechanism();
            for (SequenceMessage message : allocation.getInvokingSequenceMessages()) {
                List expectedReceiveProtocols;
                if (message.getKind() == MessageKind.REPLY) continue;
                boolean hasReply = ScenarioExt.hasReply((SequenceMessage)message);
                EObject scenario = EcoreUtil2.getFirstContainer((EObject)message, (EClass)InteractionPackage.Literals.SCENARIO);
                List expectedSendProtocols = LinkCompatibilityDefinition.INSTANCE.getCompatibleProtocols(true, mechanism, message.getKind(), hasReply);
                if (!expectedSendProtocols.isEmpty() && !expectedSendProtocols.contains(allocation.getSendProtocol())) {
                    String expected = ListExt.toString((Collection)expectedSendProtocols, (String)" || ");
                    IStatus status = ctx.createFailureStatus(new Object[]{eObj, mechanism, expected, Messages.ExchangeItemAllocationProtocol_CommunicationLinkProtocol_Sender, message, message.getKind(), hasReply ? "with" : "without", scenario});
                    statuses.add(status);
                }
                if ((expectedReceiveProtocols = LinkCompatibilityDefinition.INSTANCE.getCompatibleProtocols(false, mechanism, message.getKind(), hasReply)).isEmpty() || expectedReceiveProtocols.contains(allocation.getReceiveProtocol())) continue;
                String expected = ListExt.toString((Collection)expectedReceiveProtocols, (String)" || ");
                IStatus status = ctx.createFailureStatus(new Object[]{eObj, mechanism, expected, Messages.ExchangeItemAllocationProtocol_CommunicationLinkProtocol_Receiver, message, message.getKind(), hasReply ? "with" : "without", scenario});
                statuses.add(status);
            }
            if (statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
            }
        }
        return ctx.createSuccessStatus();
    }
}

