/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.interface_;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationPackage;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class InterfaceAndExchangeItemsLocationConsistency
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        Component source = null;
        Object targetFeatures = null;
        IStatus status = ctx.createSuccessStatus();
        MultiStatus mstatus = new MultiStatus(status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
        if (eObj instanceof InterfaceImplementation) {
            source = ((InterfaceImplementation)eObj).getInterfaceImplementor();
            this.checkFeature(ctx, mstatus, (EObject)source, eObj, (EStructuralFeature)CsPackage.Literals.INTERFACE_IMPLEMENTATION__IMPLEMENTED_INTERFACE);
        } else if (eObj instanceof InterfaceUse) {
            source = ((InterfaceUse)eObj).getInterfaceUser();
            this.checkFeature(ctx, mstatus, (EObject)source, eObj, (EStructuralFeature)CsPackage.Literals.INTERFACE_USE__USED_INTERFACE);
        } else if (eObj instanceof CommunicationLink) {
            source = (Component)eObj.eContainer();
            this.checkFeature(ctx, mstatus, (EObject)source, eObj, (EStructuralFeature)CommunicationPackage.Literals.COMMUNICATION_LINK__EXCHANGE_ITEM);
        } else if (eObj instanceof ComponentPort) {
            source = (Component)eObj.eContainer();
            this.checkFeature(ctx, mstatus, (EObject)source, eObj, (EStructuralFeature)InformationPackage.Literals.PORT__PROVIDED_INTERFACES);
            this.checkFeature(ctx, mstatus, (EObject)source, eObj, (EStructuralFeature)InformationPackage.Literals.PORT__REQUIRED_INTERFACES);
        }
        if (!mstatus.isOK()) {
            return mstatus;
        }
        return ctx.createSuccessStatus();
    }

    protected void checkFeature(IValidationContext ctx, MultiStatus status, EObject source, EObject target, EStructuralFeature targetFeature) {
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(target.eClass(), targetFeature);
        if (query != null) {
            Object values;
            List objects = query.getAvailableElements(target);
            Object featureValue = target.eGet(targetFeature);
            Object object = values = targetFeature.isMany() ? (EList)featureValue : Collections.singletonList(featureValue);
            if (source != null && target != null) {
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    EObject value = (EObject)iterator.next();
                    if (value == null || objects.contains(value)) continue;
                    status.add(ctx.createFailureStatus(new Object[]{EObjectLabelProviderHelper.getText((EObject)source), EObjectLabelProviderHelper.getText((EObject)value), EObjectLabelProviderHelper.getText((EObject)target), target.eClass().getName()}));
                }
            }
        }
    }
}

