/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.model;

import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.polarsys.capella.core.commands.preferences.service.IItemDescriptor;

public class CategoryPreferences
implements Comparable<CategoryPreferences> {
    static final String SLASH = "/";
    public static final CategoryPreferences GLOBAL_NAMESPACE = new CategoryPreferences("", null);
    static final CategoryPreferences DEFAULT_CATEGORY = new CategoryPreferences("", GLOBAL_NAMESPACE);
    private static Collator collator;
    private final String id;
    private String path;
    private String name;
    private String qualifiedName;
    private String description;
    private boolean mandatory;
    private final CategoryPreferences parent;
    private final Map<String, CategoryPreferences> childrens = new HashMap<String, CategoryPreferences>();
    private Set<IItemDescriptor> items = new HashSet<IItemDescriptor>();

    public void setItems(Set<IItemDescriptor> items) {
        this.items = items;
    }

    public CategoryPreferences(String id, CategoryPreferences parent) {
        assert (id != null);
        this.id = id;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public final String getId() {
        return this.id;
    }

    public final String getPath() {
        if (this.path == null) {
            this.path = this.getParent() == null ? this.getId() : String.valueOf(this.getParent().getPath()) + SLASH + this.getId();
        }
        return this.path;
    }

    public final String getName() {
        return this.name;
    }

    public final String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.getParent() == null ? this.getName() : String.valueOf(this.getParent().getQualifiedName()) + SLASH + this.getName();
        }
        return this.qualifiedName;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<IItemDescriptor> getItems() {
        return Collections.unmodifiableSet(this.items);
    }

    public void addItem(IItemDescriptor constraint) {
        if (!this.items.contains(constraint)) {
            this.items.add(constraint);
            constraint.addCategory(this);
        }
    }

    public void removeItem(IItemDescriptor item) {
        if (this.items.contains(item)) {
            this.items.remove(item);
            item.removeCategory(this);
        }
    }

    public CategoryPreferences getParent() {
        CategoryPreferences result = this.getParentInternal();
        if (result == GLOBAL_NAMESPACE) {
            result = null;
        }
        return result;
    }

    private CategoryPreferences getParentInternal() {
        return this.parent;
    }

    public SortedSet<CategoryPreferences> getChildren() {
        return Collections.unmodifiableSortedSet(new TreeSet<CategoryPreferences>(this.childrens.values()));
    }

    public CategoryPreferences getChild(String childId) {
        return this.childrens.get(childId);
    }

    public CategoryPreferences getDescendent(String descendentPath) {
        return this.getDescendent(descendentPath, false);
    }

    public boolean hasChildren() {
        return !this.childrens.values().isEmpty();
    }

    CategoryPreferences getDescendent(String descendentPath, boolean create) {
        if (descendentPath.startsWith(SLASH)) {
            return this.getDescendent(descendentPath.substring(1), create);
        }
        int slash = descendentPath.indexOf(SLASH);
        if (slash < 0) {
            CategoryPreferences result = this.getChild(descendentPath);
            if (result == null && create) {
                result = new CategoryPreferences(descendentPath, this);
            }
            return result;
        }
        String childId = descendentPath.substring(0, slash);
        CategoryPreferences child = this.getChild(childId);
        if (child == null) {
            if (!create) {
                return null;
            }
            child = new CategoryPreferences(childId, this);
        }
        return child.getDescendent(descendentPath.substring(slash + 1), create);
    }

    public final void setName(String name) {
        assert (name != null);
        this.name = name;
        this.qualifiedName = null;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean b) {
        this.mandatory = b;
    }

    private void addChild(CategoryPreferences child) {
        String newId = child.getId();
        if (this.childrens.containsKey(newId)) {
            this.removeChild(newId);
        }
        this.childrens.put(newId, child);
    }

    void removeChild(String childId) {
        this.childrens.remove(childId);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof CategoryPreferences && ((CategoryPreferences)other).getPath().equals(this.getPath());
    }

    static Collator getCollator() {
        if (collator == null) {
            collator = Collator.getInstance();
        }
        return collator;
    }

    @Override
    public int compareTo(CategoryPreferences other) {
        Collator aCollator = CategoryPreferences.getCollator();
        int result = aCollator.compare(this.getName(), other.getName());
        if (result == 0) {
            result = aCollator.compare(this.getPath(), other.getPath());
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(32);
        result.append("Category[path=");
        result.append(this.getPath());
        result.append(", name=");
        result.append(this.getName());
        result.append(']');
        return result.toString();
    }

    void getMandatoryCategories(Collection<? super CategoryPreferences> collection) {
        if (this.isMandatory()) {
            collection.add(this);
        }
        for (CategoryPreferences next : this.getChildren()) {
            next.getMandatoryCategories(collection);
        }
    }
}

