/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.preferences.Activator;

public class ScopedCapellaPreferencesStore
extends ScopedPreferenceStore {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private static ScopedCapellaPreferencesStore instance;
    public static Map<String, String> DEFAULT_OPTIONS_MAP;
    private static Map<String, String> options;
    public static Map<FieldEditor, String> fields;
    private static final Map<IProject, IScopeContext> projectScopes;
    private static final String PREFERENCE_SEPARATOR = ".";

    static {
        projectScopes = new HashMap<IProject, IScopeContext>(0);
        options = new HashMap<String, String>();
        DEFAULT_OPTIONS_MAP = Collections.unmodifiableMap(options);
        fields = new HashMap<FieldEditor, String>(0);
    }

    private ScopedCapellaPreferencesStore(String pluginId) {
        super(InstanceScope.INSTANCE, pluginId);
    }

    public static ScopedCapellaPreferencesStore getInstance(String pluginID_p) {
        if (instance == null) {
            instance = new ScopedCapellaPreferencesStore("org.polarsys.capella.core.preferences");
        }
        return instance;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        if (Activator.getDefault().getPropertyPreferenceStore((IResource)PreferencesHelper.getSelectedCapellaProject()) == null) {
            super.firePropertyChangeEvent(name, oldValue, newValue);
        }
    }

    protected static void putBoolean(IProject project, String optionName, boolean value) {
        String key = project != null ? String.valueOf(project.getName()) + PREFERENCE_SEPARATOR + optionName : optionName;
        IEclipsePreferences instanceNode = InstanceScope.INSTANCE.getNode("org.polarsys.capella.core.preferences");
        IEclipsePreferences defaultNode = DefaultScope.INSTANCE.getNode("org.polarsys.capella.core.preferences");
        String instanceValue = Platform.getPreferencesService().get(optionName, null, (Preferences[])new IEclipsePreferences[]{instanceNode});
        String defaultValue = Platform.getPreferencesService().get(optionName, null, (Preferences[])new IEclipsePreferences[]{defaultNode});
        if (instanceValue == null) {
            instanceNode.put(key, instanceNode.get(key, String.valueOf(value)));
            ScopedCapellaPreferencesStore.flushPreference(instanceNode);
        }
        if (defaultValue == null) {
            defaultNode.put(key, defaultNode.get(key, String.valueOf(value)));
            ScopedCapellaPreferencesStore.flushPreference(defaultNode);
        }
    }

    protected static void putInt(IProject project, String optionName, int value) {
        String key = project != null ? String.valueOf(project.getName()) + PREFERENCE_SEPARATOR + optionName : optionName;
        IEclipsePreferences instanceNode = InstanceScope.INSTANCE.getNode("org.polarsys.capella.core.preferences");
        IEclipsePreferences defaultNode = DefaultScope.INSTANCE.getNode("org.polarsys.capella.core.preferences");
        String instanceValue = Platform.getPreferencesService().get(optionName, null, (Preferences[])new IEclipsePreferences[]{instanceNode});
        String defaultValue = Platform.getPreferencesService().get(optionName, null, (Preferences[])new IEclipsePreferences[]{defaultNode});
        if (instanceValue == null) {
            instanceNode.putInt(key, instanceNode.getInt(key, value));
            ScopedCapellaPreferencesStore.flushPreference(instanceNode);
        }
        if (defaultValue == null) {
            defaultNode.putInt(key, instanceNode.getInt(key, value));
            ScopedCapellaPreferencesStore.flushPreference(defaultNode);
        }
    }

    protected static void putString(IProject project, String optionName, String value) {
        String key = project != null ? String.valueOf(project.getName()) + PREFERENCE_SEPARATOR + optionName : optionName;
        IEclipsePreferences instanceNode = InstanceScope.INSTANCE.getNode("org.polarsys.capella.core.preferences");
        IEclipsePreferences defaultNode = DefaultScope.INSTANCE.getNode("org.polarsys.capella.core.preferences");
        String instanceValue = Platform.getPreferencesService().get(optionName, null, (Preferences[])new IEclipsePreferences[]{instanceNode});
        String defaultValue = Platform.getPreferencesService().get(optionName, null, (Preferences[])new IEclipsePreferences[]{defaultNode});
        if (instanceValue == null) {
            instanceNode.put(key, instanceNode.get(key, String.valueOf(value)));
            ScopedCapellaPreferencesStore.flushPreference(instanceNode);
        }
        if (defaultValue == null) {
            defaultNode.put(key, instanceNode.get(key, String.valueOf(value)));
            ScopedCapellaPreferencesStore.flushPreference(defaultNode);
        }
    }

    public boolean getBoolean(String name) {
        return ScopedCapellaPreferencesStore.getBoolean(true, name);
    }

    public String getString(String name) {
        return ScopedCapellaPreferencesStore.getString(true, name);
    }

    public int getInt(String name) {
        return ScopedCapellaPreferencesStore.getInt(true, name);
    }

    @Deprecated
    public static boolean getBoolean(boolean inProjectScope, String optionName) {
        IProject selectedCapellaProject = PreferencesHelper.getSelectedCapellaProject();
        return ScopedCapellaPreferencesStore.getBoolean(inProjectScope, optionName, selectedCapellaProject);
    }

    @Deprecated
    public static boolean getBoolean(String preferenceName, Object contentChild_p) {
        if (contentChild_p instanceof Project && PreferencesHelper.getProject((EObject)((Project)contentChild_p)) != null) {
            return ScopedCapellaPreferencesStore.getBoolean(true, preferenceName, PreferencesHelper.getProject((EObject)((Project)contentChild_p)));
        }
        return ScopedCapellaPreferencesStore.getBoolean(true, preferenceName);
    }

    private static IProject adapt(IProject selectedCapellaProject) {
        if (PreferencesHelper.hasConfigurationProject(selectedCapellaProject)) {
            return PreferencesHelper.getReferencedProjectConfiguration(selectedCapellaProject);
        }
        return selectedCapellaProject;
    }

    @Deprecated
    public static boolean getBoolean(boolean inProjectScope, String optionName, IProject selectedCapellaProject) {
        IProject project;
        if (inProjectScope && selectedCapellaProject != null && ScopedCapellaPreferencesStore.getProjectValue(project = ScopedCapellaPreferencesStore.adapt(selectedCapellaProject), optionName) != null && ScopedCapellaPreferencesStore.getProjectValue(project, optionName) instanceof String) {
            return Boolean.valueOf((String)ScopedCapellaPreferencesStore.getProjectValue(project, optionName));
        }
        return Activator.getDefault().getPreferenceStore().getBoolean(optionName);
    }

    @Deprecated
    public static int getInt(boolean inProjectScope, String optionName) {
        IProject project;
        IProject selectedCapellaProject = PreferencesHelper.getSelectedCapellaProject();
        if (inProjectScope && selectedCapellaProject != null && ScopedCapellaPreferencesStore.getProjectValue(project = ScopedCapellaPreferencesStore.adapt(selectedCapellaProject), optionName) != null && ScopedCapellaPreferencesStore.getProjectValue(project, optionName) instanceof String) {
            return Integer.valueOf((String)ScopedCapellaPreferencesStore.getProjectValue(project, optionName));
        }
        return Activator.getDefault().getPreferenceStore().getInt(optionName);
    }

    @Deprecated
    public static String getString(boolean inProjectScope, String optionName) {
        IProject project;
        IProject selectedCapellaProject = PreferencesHelper.getSelectedCapellaProject();
        if (inProjectScope && selectedCapellaProject != null && ScopedCapellaPreferencesStore.getProjectValue(project = ScopedCapellaPreferencesStore.adapt(selectedCapellaProject), optionName) != null && ScopedCapellaPreferencesStore.getProjectValue(project, optionName) instanceof String) {
            return (String)ScopedCapellaPreferencesStore.getProjectValue(project, optionName);
        }
        return Activator.getDefault().getPreferenceStore().getString(optionName);
    }

    public boolean containsKey(String optionName) {
        IProject selectedCapellaProject = PreferencesHelper.getSelectedCapellaProject();
        return ScopedCapellaPreferencesStore.containsKey(true, optionName, selectedCapellaProject);
    }

    @Deprecated
    public static boolean containsKey(boolean inProjectScope, String optionName, IProject selectedCapellaProject) {
        if (inProjectScope && selectedCapellaProject != null) {
            IProject configuration;
            if (PreferencesHelper.hasConfigurationProject(selectedCapellaProject) && ScopedCapellaPreferencesStore.getProjectValue(configuration = PreferencesHelper.getReferencedProjectConfiguration(selectedCapellaProject), optionName) != null) {
                return true;
            }
            if (ScopedCapellaPreferencesStore.getProjectValue(selectedCapellaProject, optionName) != null) {
                return true;
            }
        }
        return Activator.getDefault().getPreferenceStore().contains(optionName);
    }

    @Deprecated
    public static Object getValueFromPresistentPropertyStore(IProject resource, String key) {
        return ScopedCapellaPreferencesStore.getProjectValue(resource, key);
    }

    public static Object getProjectValue(IProject resource, String key) {
        try {
            if (resource.isAccessible() && resource.isOpen()) {
                Map properties = resource.getPersistentProperties() != null ? resource.getPersistentProperties() : new HashMap(0);
                for (QualifiedName qualifiedName : properties.keySet()) {
                    QualifiedName qualified = qualifiedName;
                    if (!key.equals(qualified.getLocalName())) continue;
                    return properties.get(qualifiedName);
                }
            }
        }
        catch (CoreException exception_p1) {
            StringBuilder loggerMessage = new StringBuilder("Activator.initializePropertyStore(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p1);
        }
        return null;
    }

    public void setValue(String name, boolean value) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (PreferencesHelper.hasConfigurationProject(project)) {
                IProject configuration = PreferencesHelper.getReferencedProjectConfiguration(project);
                if (this.getDefaultBoolean(name) == value) {
                    new ProjectScope(configuration).getNode("org.polarsys.capella.core.preferences").remove(name);
                } else {
                    new ProjectScope(configuration).getNode("org.polarsys.capella.core.preferences").putBoolean(name, value);
                }
            }
            ++n2;
        }
        if (this.getDefaultBoolean(name) == value) {
            InstanceScope.INSTANCE.getNode("org.polarsys.capella.core.preferences").remove(name);
        } else {
            InstanceScope.INSTANCE.getNode("org.polarsys.capella.core.preferences").putBoolean(name, value);
        }
    }

    public void setValue(String name, String value) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (PreferencesHelper.hasConfigurationProject(project)) {
                IProject configuration = PreferencesHelper.getReferencedProjectConfiguration(project);
                if (this.getDefaultString(name) == value) {
                    new ProjectScope(configuration).getNode("org.polarsys.capella.core.preferences").remove(name);
                } else {
                    new ProjectScope(configuration).getNode("org.polarsys.capella.core.preferences").put(name, value);
                }
            }
            ++n2;
        }
        if (this.getDefaultString(name) == value) {
            InstanceScope.INSTANCE.getNode("org.polarsys.capella.core.preferences").remove(name);
        } else {
            InstanceScope.INSTANCE.getNode("org.polarsys.capella.core.preferences").put(name, value);
        }
    }

    public void save() {
        try {
            Platform.getPreferencesService().getRootNode().flush();
        }
        catch (BackingStoreException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("ScopedPreferenceManager.save(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
    }

    private static void flushPreference(IEclipsePreferences node) {
        try {
            node.flush();
        }
        catch (BackingStoreException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("ScopedPreferenceManager.flushPreference(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
    }

    @Deprecated
    public boolean contains(String name) {
        boolean contains = super.contains(name);
        IProject selectedCapellaProject = PreferencesHelper.getSelectedCapellaProject();
        IPreferencesService service = Platform.getPreferencesService();
        String key = selectedCapellaProject != null && !name.contains(selectedCapellaProject.getName()) ? String.valueOf(selectedCapellaProject.getName()) + PREFERENCE_SEPARATOR + name : name;
        IScopeContext[] contexts = selectedCapellaProject != null ? new IScopeContext[]{ScopedCapellaPreferencesStore.getProjectScope(selectedCapellaProject), InstanceScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        contains = service.getString("org.polarsys.capella.core.preferences", key, null, contexts) != null;
        return contains;
    }

    @Deprecated
    public static IScopeContext getProjectScope(IProject project) {
        IProject realProject = project.getProject();
        if (projectScopes.get(realProject) != null) {
            return projectScopes.get(realProject);
        }
        return new ProjectScope(realProject);
    }

    @Deprecated
    public static Map<String, String> getOptions() {
        return options;
    }

    @Deprecated
    public static Map<IProject, IScopeContext> getProjectContexts() {
        return projectScopes;
    }
}

