/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.core.commands.preferences.internalization.l10n.PreferencesUIMessages;
import org.polarsys.capella.core.commands.preferences.model.CategoryPreferences;
import org.polarsys.capella.core.commands.preferences.model.CategoryTreeNode;
import org.polarsys.capella.core.commands.preferences.model.ICategoryTreeNode;
import org.polarsys.capella.core.commands.preferences.model.IItemNode;
import org.polarsys.capella.core.commands.preferences.model.ItemNode;
import org.polarsys.capella.core.commands.preferences.preferences.ConfigurabilityPreferences;
import org.polarsys.capella.core.commands.preferences.service.IItemFilter;
import org.polarsys.capella.core.commands.preferences.ui.CategoriesPreferencesFilter;
import org.polarsys.capella.core.commands.preferences.ui.PreferencesFilter;
import org.polarsys.capella.core.commands.preferences.util.GUIUtil;
import org.polarsys.capella.core.preferences.Activator;

public class CommandSelectionContainer {
    private static final String LOCK_ICON = "icons/lock.gif";
    static final String CATEGORIES_PROMPT = PreferencesUIMessages.prefs_categories_prompt;
    static final String CONSTRAINTS_PROMPT = PreferencesUIMessages.prefs_constraints_prompt;
    static final String NO_SELECTION = PreferencesUIMessages.prefs_no_selection;
    static final String NO_CATEGORY_DESCRIPTION = PreferencesUIMessages.prefs_no_description_category;
    private CheckboxTreeViewer categoryTree;
    private CheckboxTableViewer itemList;
    private StyledText detailsArea;
    private Mediator mediator;
    private ICategoryTreeNode rootcategory;
    private final IItemFilter filter;
    private PreferencesFilter preferenceFilter;
    private CategoriesPreferencesFilter categoriesFilter;

    public CommandSelectionContainer() {
        this(IItemFilter.IDENTITY_INSTANCE);
    }

    public CommandSelectionContainer(IItemFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("null filter");
        }
        this.filter = filter;
    }

    public Composite createComposite(Composite parent) {
        SashForm parentFormComposite = new SashForm(parent, 512);
        parentFormComposite.setFont(parent.getFont());
        final Text searchText = new Text((Composite)parentFormComposite, 2176);
        searchText.setLayoutData((Object)new GridData(768));
        GUIUtil.addPrompt(searchText, PreferencesUIMessages.CommandSelectionContainer_Filtering);
        SashForm topPart = new SashForm((Composite)parentFormComposite, 256);
        this.createCategoryTree((Composite)topPart);
        this.createItemList((Composite)topPart);
        this.createDetailsArea((Composite)parentFormComposite);
        searchText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                CommandSelectionContainer.this.preferenceFilter.setSearchValue(searchText.getText());
                CommandSelectionContainer.this.itemList.refresh();
                CommandSelectionContainer.this.categoryTree.refresh();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        searchText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                CommandSelectionContainer.this.preferenceFilter.setSearchValue(searchText.getText());
                CommandSelectionContainer.this.itemList.refresh();
                CommandSelectionContainer.this.categoryTree.refresh();
            }

            public void keyPressed(KeyEvent e) {
                CommandSelectionContainer.this.preferenceFilter.setSearchValue(searchText.getText());
                CommandSelectionContainer.this.itemList.refresh();
                CommandSelectionContainer.this.categoryTree.refresh();
            }
        });
        this.preferenceFilter = new PreferencesFilter();
        this.categoriesFilter = new CategoriesPreferencesFilter();
        this.itemList.addFilter((ViewerFilter)this.preferenceFilter);
        this.categoryTree.addFilter((ViewerFilter)this.categoriesFilter);
        parentFormComposite.setWeights(new int[]{7, 80, 13});
        return parentFormComposite;
    }

    private Control createCategoryTree(Composite parent) {
        Composite form = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        form.setLayout((Layout)layout);
        Label prompt = new Label(form, 0);
        prompt.setText(CATEGORIES_PROMPT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        prompt.setLayoutData((Object)data);
        this.categoryTree = new CheckboxTreeViewer(form);
        data = new FormData();
        data.top = new FormAttachment((Control)prompt, 4);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.categoryTree.getControl().setLayoutData((Object)data);
        this.rootcategory = CategoryTreeNode.createRoot(this.categoryTree, this.filter);
        this.categoryTree.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private final Image lockImage = Activator.getImageDescriptor("icons/lock.gif").createImage(true);

            public void dispose() {
                this.lockImage.dispose();
                super.dispose();
            }

            public Image getImage(Object element) {
                ICategoryTreeNode node = (ICategoryTreeNode)element;
                if (node.getCategory() != null && node.getCategory().isMandatory()) {
                    return this.lockImage;
                }
                return null;
            }
        });
        this.categoryTree.setContentProvider((IContentProvider)new CategoryTreeContents());
        this.categoryTree.setInput((Object)this.rootcategory);
        this.markEnabledCategories(this.rootcategory);
        this.categoryTree.addCheckStateListener((ICheckStateListener)this.getMediator());
        this.categoryTree.addSelectionChangedListener((ISelectionChangedListener)this.getMediator());
        return this.categoryTree.getTree();
    }

    private Control createItemList(Composite parent) {
        Composite form = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        form.setLayout((Layout)layout);
        Label prompt = new Label(form, 0);
        prompt.setText(CONSTRAINTS_PROMPT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        prompt.setLayoutData((Object)data);
        this.itemList = CheckboxTableViewer.newCheckList((Composite)form, (int)2080);
        data = new FormData();
        data.top = new FormAttachment((Control)prompt, 4);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.itemList.getControl().setLayoutData((Object)data);
        this.itemList.setContentProvider((IContentProvider)new ItemListContents());
        this.itemList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IItemNode)element).getName();
            }
        });
        this.itemList.setSorter(new ViewerSorter());
        this.itemList.addCheckStateListener((ICheckStateListener)this.getMediator());
        this.itemList.addSelectionChangedListener((ISelectionChangedListener)this.getMediator());
        return this.itemList.getControl();
    }

    private Control createDetailsArea(Composite parent) {
        this.detailsArea = new StyledText(parent, 2634);
        this.getMediator().clearDetailsArea();
        return this.detailsArea;
    }

    private CheckboxTreeViewer getCategoryTree() {
        return this.categoryTree;
    }

    private CheckboxTableViewer getItemList() {
        return this.itemList;
    }

    private StyledText getDetailsArea() {
        return this.detailsArea;
    }

    private Mediator getMediator() {
        if (this.mediator == null) {
            this.mediator = new Mediator();
        }
        return this.mediator;
    }

    public boolean performOk() {
        this.rootcategory.applyToPreferences();
        ConfigurabilityPreferences.save();
        return true;
    }

    public void performDefaults() {
        Object[] elements;
        this.rootcategory.restoreDefaults();
        CheckboxTableViewer viewer = this.getItemList();
        Object input = viewer.getInput();
        if (input != null && (elements = ((IStructuredContentProvider)this.getItemList().getContentProvider()).getElements(input)) != null) {
            int length = elements.length;
            int i = 0;
            while (i < length) {
                IItemNode node = (IItemNode)elements[i];
                viewer.setChecked((Object)node, node.isChecked());
                ++i;
            }
        }
    }

    private CategoryPreferences getCurrentCategorySelection() {
        IStructuredSelection selection = (IStructuredSelection)this.getCategoryTree().getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return ((ICategoryTreeNode)selection.getFirstElement()).getCategory();
    }

    private void markEnabledCategories(ICategoryTreeNode root) {
        this.markEnabledCategories(root.getChildren());
    }

    private void markEnabledCategories(ICategoryTreeNode[] categories) {
        ICategoryTreeNode[] iCategoryTreeNodeArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            ICategoryTreeNode next = iCategoryTreeNodeArray[n2];
            this.getCategoryTree().setChecked((Object)next, next.isChecked());
            this.getCategoryTree().setGrayed((Object)next, next.isGrayed());
            this.markEnabledCategories(next.getChildren());
            ++n2;
        }
    }

    public void dispose() {
        ItemNode.flushCache();
    }

    private class CategoryTreeContents
    implements ITreeContentProvider {
        private CategoryTreeContents() {
        }

        public Object[] getChildren(Object parentElement) {
            return ((ICategoryTreeNode)parentElement).getChildren();
        }

        public Object getParent(Object element) {
            return ((ICategoryTreeNode)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((ICategoryTreeNode)element).hasChildren();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ItemListContents
    implements IStructuredContentProvider,
    ICheckStateListener {
        private CheckboxTableViewer viewer;
        private ICategoryTreeNode category;

        private ItemListContents() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            this.category = (ICategoryTreeNode)inputElement;
            return this.category.getItems().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
            if (this.viewer != null) {
                this.viewer.removeCheckStateListener((ICheckStateListener)this);
            }
            this.viewer = (CheckboxTableViewer)newViewer;
            this.category = (ICategoryTreeNode)newInput;
            if (this.viewer != null) {
                this.viewer.addCheckStateListener((ICheckStateListener)this);
            }
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            this.category.updateCheckState((IItemNode)event.getElement());
        }
    }

    private class Mediator
    implements ISelectionChangedListener,
    ICheckStateListener {
        private boolean respondingToUserSelection;

        private Mediator() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (element instanceof ICategoryTreeNode) {
                ICategoryTreeNode node = (ICategoryTreeNode)element;
                if (this.respondingToUserSelection) return;
                this.respondingToUserSelection = true;
                try {
                    node.checkStateChanged(event);
                    IStructuredSelection selection = (IStructuredSelection)CommandSelectionContainer.this.getCategoryTree().getSelection();
                    if (selection.isEmpty()) return;
                    this.selectCategory((ICategoryTreeNode)selection.getFirstElement());
                    return;
                }
                finally {
                    this.respondingToUserSelection = false;
                }
            }
            IItemNode node = (IItemNode)element;
            if (this.respondingToUserSelection) return;
            this.respondingToUserSelection = true;
            try {
                node.checkStateChanged(event);
                return;
            }
            finally {
                this.respondingToUserSelection = false;
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (event.getSource().equals(CommandSelectionContainer.this.getCategoryTree())) {
                this.handleCategorySelection(selection);
            } else if (event.getSource().equals(CommandSelectionContainer.this.getItemList())) {
                this.handleItemSelection(selection);
            }
        }

        private void handleCategorySelection(IStructuredSelection selection) {
            if (!selection.isEmpty()) {
                this.selectCategory((ICategoryTreeNode)selection.getFirstElement());
            } else {
                CommandSelectionContainer.this.getItemList().setInput(null);
                this.clearDetailsArea();
            }
        }

        private void selectCategory(ICategoryTreeNode category) {
            CommandSelectionContainer.this.getItemList().setInput((Object)category);
            this.selectItems(category);
            this.setDetails(category);
        }

        private void selectItems(ICategoryTreeNode categoryNode) {
            CommandSelectionContainer.this.getItemList().setCheckedElements((Object[])categoryNode.getSelectedItems());
        }

        private void handleItemSelection(IStructuredSelection selection) {
            if (!selection.isEmpty()) {
                this.setDetails((IItemNode)selection.getFirstElement());
            } else {
                this.clearDetailsArea();
            }
        }

        void clearDetailsArea() {
            CommandSelectionContainer.this.getDetailsArea().setText(NO_SELECTION);
        }

        private void setDetails(ICategoryTreeNode category) {
            CategoryPreferences actualCategory;
            String description;
            String string = description = category == null ? null : category.getDescription();
            if (description == null) {
                description = NO_CATEGORY_DESCRIPTION;
            }
            if ((actualCategory = category.getCategory()) != null && actualCategory.isMandatory()) {
                CommandSelectionContainer.this.getDetailsArea().setText(MessageFormat.format(PreferencesUIMessages.prefs_mandatory_category, description));
            } else {
                CommandSelectionContainer.this.getDetailsArea().setText(description);
            }
        }

        private void setDetails(IItemNode constraint) {
            ArrayList styles = new ArrayList(32);
            CommandSelectionContainer.this.getDetailsArea().setText(constraint.getDescription());
            CommandSelectionContainer.this.getDetailsArea().setStyleRanges(styles.toArray(new StyleRange[styles.size()]));
        }
    }
}

