/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeEditor;
import org.eclipse.sirius.ui.business.api.action.RefreshActionListenerRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class EditorRefreshAction
implements IEditorActionDelegate {
    protected IWorkbenchPart workbenchPart;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setActiveWorkbenchPart((IWorkbenchPart)targetEditor);
    }

    public void run(IAction action) {
        if (this.workbenchPart instanceof DTreeEditor) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    DTreeEditor treeEditor = (DTreeEditor)EditorRefreshAction.this.workbenchPart;
                    treeEditor.enablePropertiesUpdate(false);
                    RefreshActionListenerRegistry.INSTANCE.notifyRepresentationIsAboutToBeRefreshed((DRepresentation)treeEditor.getTreeModel());
                    treeEditor.getEditingDomain().getCommandStack().execute((Command)new RefreshRepresentationsCommand(treeEditor.getEditingDomain(), monitor, new DRepresentation[]{treeEditor.getTreeModel()}));
                    treeEditor.enablePropertiesUpdate(true);
                }
            };
            Shell activeShell = this.workbenchPart.getSite().getShell();
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(activeShell);
            try {
                monitorDialog.run(false, false, op);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)activeShell, (String)Messages.EditorRefreshAction_error, (String)e.getTargetException().getMessage());
                SiriusPlugin.getDefault().error(Messages.EditorRefreshAction_treeRefreshError, (Throwable)e);
            }
            catch (InterruptedException e) {
                MessageDialog.openInformation((Shell)activeShell, (String)Messages.EditorRefreshAction_refreshCancelled, (String)e.getMessage());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActiveWorkbenchPart(IWorkbenchPart aWorkbenchPart) {
        this.workbenchPart = aWorkbenchPart;
    }
}

