/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.services.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public abstract class AbstractUiHandler
extends AbstractHandler
implements IElementUpdater {
    protected static final String ACTIVE_PART_VARIABLE = "activePart";
    protected static final String ACTIVE_WORKBENCH_WINDOW = "activeWorkbenchWindow";

    private <T> T getAdapter(Object object, Class<T> expectedSelectionType) {
        T result = null;
        if (expectedSelectionType.isInstance(object)) {
            result = expectedSelectionType.cast(object);
        }
        if (result == null && object instanceof IAdaptable) {
            result = expectedSelectionType.cast(((IAdaptable)object).getAdapter(expectedSelectionType));
        }
        return result;
    }

    protected <T> List<T> getSelection(ExecutionEvent event, Class<T> expectedSelectionType) {
        ArrayList<T> result = new ArrayList<T>(0);
        if (event == null) {
            return result;
        }
        Object applicationContext = event.getApplicationContext();
        if (applicationContext == null) {
            return result;
        }
        if (!(applicationContext instanceof IEvaluationContext)) {
            return result;
        }
        IEvaluationContext evaluationContext = (IEvaluationContext)event.getApplicationContext();
        Object defaultVariable = evaluationContext.getDefaultVariable();
        if (defaultVariable == null) {
            return result;
        }
        if (defaultVariable instanceof Collection) {
            Collection variables = (Collection)evaluationContext.getDefaultVariable();
            for (Object currentVariable : variables) {
                T adapter = this.getAdapter(currentVariable, expectedSelectionType);
                if (adapter == null) continue;
                result.add(adapter);
            }
        }
        return result;
    }

    protected Object getVariableValue(ExecutionEvent event, String variableName) {
        Object result = null;
        if (event == null) {
            return result;
        }
        if (!(event.getApplicationContext() instanceof IEvaluationContext)) {
            return result;
        }
        IEvaluationContext applicationContext = (IEvaluationContext)event.getApplicationContext();
        if (applicationContext == null) {
            return result;
        }
        result = applicationContext.getVariable(variableName);
        return result;
    }

    public void updateElement(UIElement element, Map parameters) {
    }
}

