/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.polarsys.capella.common.ui.toolkit.dialogs.AbstractViewerDialog;
import org.polarsys.capella.common.ui.toolkit.dialogs.Messages;
import org.polarsys.capella.common.ui.toolkit.viewers.TreeAndListViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.data.AbstractData;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataContentProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataLabelProvider;

public class SelectElementsDialog
extends AbstractViewerDialog {
    public static final Object UNDEFINED_CONTEXT = AbstractData.UNDEFINED_CONTEXT;
    private Object _context;
    private Collection<? extends Object> _displayedElements;
    private DataLabelProvider _labelProvider;
    protected IContentProvider _contentProvider;
    private boolean _multiSelection;
    private List<? extends EObject> _result;
    private TreeAndListViewer _viewer;
    private int _treeViewerExpandLevel;

    public SelectElementsDialog(Shell parentShell, TransactionalEditingDomain editingDomain, AdapterFactory adapterFactory, String dialogTitle, String dialogMessage, Collection<? extends Object> displayedElements) {
        this(parentShell, editingDomain, adapterFactory, dialogTitle, dialogMessage, displayedElements, false, null);
    }

    public SelectElementsDialog(Shell parentShell, TransactionalEditingDomain editingDomain, AdapterFactory adapterFactory, String dialogTitle, String dialogMessage, Collection<? extends Object> displayedElements, boolean multiSelection, Object context) {
        this(parentShell, new DataLabelProvider(editingDomain, adapterFactory), dialogTitle, dialogMessage, displayedElements, multiSelection, context, -1);
    }

    public SelectElementsDialog(Shell parentShell, TransactionalEditingDomain editingDomain, AdapterFactory adapterFactory, String dialogTitle, String dialogMessage, Collection<? extends Object> displayedElements, boolean multiSelection, Object context, int treeViewerExpandLevel) {
        this(parentShell, new DataLabelProvider(editingDomain, adapterFactory), dialogTitle, dialogMessage, displayedElements, multiSelection, context, treeViewerExpandLevel);
    }

    public SelectElementsDialog(Shell parentShell, DataLabelProvider labelProvider, String dialogTitle, String dialogMessage, Collection<? extends Object> displayedElements, boolean multiSelection, Object context, int treeViewerExpandLevel) {
        this(parentShell, (IContentProvider)new DataContentProvider(), labelProvider, dialogTitle, dialogMessage, displayedElements, multiSelection, context, treeViewerExpandLevel);
    }

    public SelectElementsDialog(Shell parentShell, IContentProvider contentProvider, DataLabelProvider labelProvider, String dialogTitle, String dialogMessage, Collection<? extends Object> displayedElements, boolean multiSelection, Object context, int treeViewerExpandLevel) {
        super(parentShell, dialogTitle, dialogMessage, Messages.SelectElementsDialog_Shell_Title);
        this._contentProvider = contentProvider;
        this._labelProvider = labelProvider;
        this._multiSelection = multiSelection;
        this._context = context;
        this._treeViewerExpandLevel = treeViewerExpandLevel;
        this._displayedElements = displayedElements != null ? displayedElements : new ArrayList<Object>(0);
    }

    protected void configureInitialDisplay() {
        if (this._displayedElements.size() == 1) {
            TreeViewer clientViewer = this._viewer.getClientViewer();
            clientViewer.setSelection((ISelection)new StructuredSelection(this._displayedElements));
            clientViewer.getControl().setFocus();
        }
    }

    protected void createTreeViewer(Composite parent) {
        this._viewer = new TreeAndListViewer(parent, this._displayedElements, this._context, this._multiSelection, this._contentProvider, (ILabelProvider)this._labelProvider, this.getTreeViewerStyle(), this._treeViewerExpandLevel){

            @Override
            protected TreeViewer doClientViewer(Composite prt) {
                TreeViewer clientViewer = super.doClientViewer(prt);
                SelectElementsDialog.this._labelProvider.setViewer(clientViewer);
                return clientViewer;
            }
        };
        this._viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.addSelectionChangedListener();
        this.addDoubleCLickListener();
        TreeViewer clientViewer = this._viewer.getClientViewer();
        this.constrainViewer(clientViewer, this.getViewerHeighthint());
    }

    protected void addSelectionChangedListener() {
        TreeViewer clientViewer = this._viewer.getClientViewer();
        ISelectionChangedListener viewerSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SelectElementsDialog.this.updateButtons((ISelection)selection);
            }
        };
        clientViewer.addSelectionChangedListener(viewerSelectionChangedListener);
    }

    protected void addDoubleCLickListener() {
        TreeViewer clientViewer = this._viewer.getClientViewer();
        IDoubleClickListener viewerDoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
                    Object doubleClickedElement = ((StructuredSelection)selection).getFirstElement();
                    if (((AbstractData)event.getViewer().getInput()).isValid(doubleClickedElement)) {
                        SelectElementsDialog.this.okPressed();
                    }
                }
            }
        };
        clientViewer.addDoubleClickListener(viewerDoubleClickListener);
    }

    public void create() {
        super.create();
        ISelection selection = null;
        if (this.getViewer() != null && this.getViewer().getSelection() != null) {
            selection = this.getViewer().getSelection();
        }
        this.updateButtons(selection);
    }

    protected void createTreeViewerPart(Composite parent) {
        this.createTreeViewer(parent);
    }

    @Override
    protected void doCreateDialogArea(Composite parent) {
        this.createTreeViewerPart(parent);
        this.configureInitialDisplay();
    }

    protected Composite createScrolledComposite(Composite parent) {
        FormToolkit formToolkit = new FormToolkit(parent.getDisplay());
        formToolkit.setBackground(parent.getBackground());
        ScrolledForm scrolledComposite = formToolkit.createScrolledForm(parent);
        scrolledComposite.setBackground(Display.getCurrent().getSystemColor(9));
        return scrolledComposite.getBody();
    }

    @Override
    public List<? extends EObject> getResult() {
        return this._result;
    }

    protected int getTreeViewerStyle() {
        return 6;
    }

    protected TreeAndListViewer getViewer() {
        return this._viewer;
    }

    protected List<? extends EObject> handleResult() {
        return new ArrayList(((IStructuredSelection)this._viewer.getClientViewer().getSelection()).toList());
    }

    protected boolean isOkToClose(ISelection selection) {
        boolean isOkEnabled = false;
        if (selection != null && !selection.isEmpty()) {
            isOkEnabled = true;
            IStructuredSelection sel = (IStructuredSelection)selection;
            AbstractData input = (AbstractData)this._viewer.getClientViewer().getInput();
            for (Object selectedElement : sel.toList()) {
                if (!(isOkEnabled &= input.isValid(selectedElement))) break;
            }
        }
        return isOkEnabled;
    }

    protected void okPressed() {
        this._result = this.handleResult();
        super.okPressed();
    }

    protected void updateButtons(ISelection selection) {
        boolean isOkEnabled = this.isOkToClose(selection);
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(isOkEnabled);
        }
    }
}

