/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.dialogs;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.common.ui.toolkit.dialogs.AbstractViewerDialog;
import org.polarsys.capella.common.ui.toolkit.dialogs.Messages;
import org.polarsys.capella.common.ui.toolkit.viewers.data.AbstractData;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataContentProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataLabelProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.common.ui.toolkit.viewers.transfer.TransferTreeListViewer;
import org.polarsys.capella.common.ui.toolkit.widgets.handler.SelectionChangedHandler;

public class TransferTreeListDialog
extends AbstractViewerDialog {
    public static final int DEFAULT_TREE_VIEWER_STYLE = 2818;
    public static final Object UNDEFINED_CONTEXT = AbstractData.UNDEFINED_CONTEXT;
    private ITreeContentProvider _leftContentProvider;
    private Couple<List<? extends EObject>, Object> _leftInput;
    private DataLabelProvider _leftLabelProvider;
    private int _leftViewerStyle;
    private int _leftViewerExpandLevel;
    private Object[] _results;
    private ITreeContentProvider _rightContentProvider;
    private Couple<List<? extends EObject>, Object> _rightInput;
    private DataLabelProvider _rightLabelProvider;
    private int _rightViewerStyle;
    private int _rightViewerExpandLevel;
    private TransferTreeListViewer _transferViewer;
    protected final int TRANSFER_TREE_STYLE = 126;

    public TransferTreeListDialog(Shell parentShell, String dialogTitle, String dialogMessage, TransactionalEditingDomain editingDomain, AdapterFactory adapterFactory) {
        this(parentShell, dialogTitle, dialogMessage, new DataLabelProvider(editingDomain, adapterFactory), new DataLabelProvider(editingDomain, adapterFactory), 2818, 2818, -1, -1);
    }

    protected TransferTreeListDialog(Shell parentShell, String dialogTitle, String dialogMessage, DataLabelProvider leftLabelProvider, DataLabelProvider rightLabelProvider, int leftViewerStyle, int rightViewerStyle, int leftViewerExpandLevel, int rightViewerExpandLevel) {
        super(parentShell, dialogTitle, dialogMessage, Messages.TransferTreeListDialog_Shell_Title);
        this._leftLabelProvider = leftLabelProvider;
        this._leftViewerStyle = leftViewerStyle;
        this._leftViewerExpandLevel = leftViewerExpandLevel;
        this._rightLabelProvider = rightLabelProvider;
        this._rightViewerStyle = rightViewerStyle;
        this._rightViewerExpandLevel = rightViewerExpandLevel;
    }

    public TransferTreeListDialog(Shell parentShell, String dialogTitle, String dialogMessage, DataLabelProvider leftLabelProvider, DataLabelProvider rightLabelProvider) {
        this(parentShell, dialogTitle, dialogMessage, leftLabelProvider, rightLabelProvider, 2818, 2818, -1, -1);
    }

    public TransferTreeListDialog(Shell parentShell, String dialogTitle, String dialogMessage, DataLabelProvider leftLabelProvider, DataLabelProvider rightLabelProvider, int leftViewerExpandLevel, int rightViewerExpandLevel) {
        this(parentShell, dialogTitle, dialogMessage, leftLabelProvider, rightLabelProvider, 2818, 2818, leftViewerExpandLevel, rightViewerExpandLevel);
    }

    protected AbstractData createRightViewerData(List<? extends EObject> elements, Object context) {
        return new TreeData(elements, context);
    }

    protected TransferTreeListViewer createTransferTreeListViewer(Composite parent) {
        return new TransferTreeListViewer(parent, 126, this._leftViewerStyle, this._rightViewerStyle, this._leftViewerExpandLevel, this._rightViewerExpandLevel);
    }

    @Override
    protected void doCreateDialogArea(Composite parent) {
        this._transferViewer = this.createTransferTreeListViewer(parent);
        this.initializeLeftViewer(this._transferViewer);
        this.initializeRightViewer(this._transferViewer);
        int widthLeft = this._transferViewer.getLeftViewer().getControl().computeSize((int)-1, (int)-1).x;
        int widthRight = this._transferViewer.getRightViewer().getControl().computeSize((int)-1, (int)-1).x;
        int widhtHint = Math.max(widthLeft, widthRight);
        this.constrainViewer(this._transferViewer.getLeftViewer(), this.getViewerHeighthint(), widhtHint);
        this.constrainViewer(this._transferViewer.getRightViewer(), this.getViewerHeighthint(), widhtHint);
        this.registerSelectionHandler(this._transferViewer);
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        result.getShell().setMinimumSize(1024, 688);
        return result;
    }

    protected ITreeContentProvider getLeftContentProvider() {
        if (this._leftContentProvider == null) {
            DataContentProvider dataContentProvider = new DataContentProvider();
            dataContentProvider.setExpandingNewContent(true);
            this._leftContentProvider = dataContentProvider;
        }
        return this._leftContentProvider;
    }

    protected DataLabelProvider getLeftLabelProvider() {
        return this._leftLabelProvider;
    }

    protected int getLeftViewerStyle() {
        return this._leftViewerStyle;
    }

    public Object[] getResult() {
        return this._results;
    }

    protected ITreeContentProvider getRightContentProvider() {
        if (this._rightContentProvider == null) {
            DataContentProvider dataContentProvider = new DataContentProvider();
            dataContentProvider.setExpandingNewContent(true);
            this._rightContentProvider = dataContentProvider;
        }
        return this._rightContentProvider;
    }

    protected DataLabelProvider getRightLabelProvider() {
        return this._rightLabelProvider;
    }

    protected int getRightViewerStyle() {
        return this._rightViewerStyle;
    }

    public TransferTreeListViewer getTransferViewer() {
        return this._transferViewer;
    }

    protected boolean handleSelectionForAddAndRemoveButton(AbstractData initialInput, ISelection selection) {
        boolean result = false;
        if (!selection.isEmpty()) {
            Object[] selectedElements;
            result = true;
            StructuredSelection sel = (StructuredSelection)selection;
            Object[] objectArray = selectedElements = sel.toArray();
            int n = selectedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (!(result &= initialInput.isValid(object))) break;
                ++n2;
            }
        }
        return result;
    }

    protected void initializeLeftViewer(TransferTreeListViewer transferViewer) {
        this._transferViewer.setLeftContentProvider((IContentProvider)this.getLeftContentProvider());
        DataLabelProvider leftLabelProvider = this.getLeftLabelProvider();
        this._transferViewer.setLeftLabelProvider((ILabelProvider)leftLabelProvider);
        TreeViewer leftViewer = this._transferViewer.getLeftViewer();
        leftLabelProvider.setViewer(leftViewer);
        List elements = (List)this._leftInput.getKey();
        TreeData leftInput = new TreeData(elements, this._leftInput.getValue());
        this._transferViewer.setLeftInput(leftInput);
        if (elements.size() == 1 && this._leftViewerExpandLevel > 0) {
            leftViewer.setSelection((ISelection)new StructuredSelection(elements.get(0)), true);
            leftViewer.getControl().setFocus();
        }
    }

    protected void initializeRightViewer(TransferTreeListViewer transferViewer) {
        this._transferViewer.setRightContentProvider((IContentProvider)this.getRightContentProvider());
        DataLabelProvider rightLabelProvider = this.getRightLabelProvider();
        this._transferViewer.setRightLabelProvider((ILabelProvider)rightLabelProvider);
        TreeViewer rightViewer = this._transferViewer.getRightViewer();
        rightLabelProvider.setViewer(rightViewer);
        AbstractData rightInput = this.createRightViewerData((List)this._rightInput.getKey(), this._rightInput.getValue());
        this._transferViewer.setRightInput(rightInput);
    }

    protected void okPressed() {
        this._results = this.getTransferViewer().getRightInput().getValidElements().toArray();
        super.okPressed();
    }

    protected void registerSelectionHandler(final TransferTreeListViewer transferViewer) {
        transferViewer.setSelectionChangedHandler(new SelectionChangedHandler(){

            @Override
            protected boolean doHandleSelection(ISelection selection) {
                return TransferTreeListDialog.this.handleSelectionForAddAndRemoveButton(transferViewer.getLeftInput(), selection);
            }
        }, 8);
        transferViewer.setSelectionChangedHandler(new SelectionChangedHandler(){

            @Override
            protected boolean doHandleSelection(ISelection selection) {
                return TransferTreeListDialog.this.handleSelectionForAddAndRemoveButton(transferViewer.getRightInput(), selection);
            }
        }, 16);
        transferViewer.getLeftViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        transferViewer.getRightViewer().setSelection((ISelection)StructuredSelection.EMPTY);
    }

    public void setLeftContentProvider(DataContentProvider leftContentProvider) {
        this._leftContentProvider = leftContentProvider;
    }

    public void setLeftInput(List<? extends EObject> elements, Object context) {
        this._leftInput = new Couple(elements, context);
    }

    public void setRightContentProvider(DataContentProvider rightContentProvider) {
        this._rightContentProvider = rightContentProvider;
    }

    public void setRightInput(List<? extends EObject> elements, Object context) {
        this._rightInput = new Couple(elements, context);
    }
}

