/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.util;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.MultiplicityElement;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datavalue.AbstractExpressionValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.datavalue.NumericReference;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;

public class PropertyNamingHelper {
    private static final String UNDEFINED = "undefined";
    private static final String SQUARE_BRACKETS_FORMAT = "[%s]";
    private static final String SQUARE_BRACKETS_WITH_DOTS_FORMAT = "[%s..%s]";

    public static String getSymbolIfPropertyIsDerived(Property property) {
        if (property != null && property.isIsDerived()) {
            return String.valueOf('/');
        }
        return "";
    }

    public static String multiplicityToStringDisplay(MultiplicityElement element) {
        String ownedmaxCardName;
        NumericValue ownedMinCard = element.getOwnedMinCard();
        NumericValue ownedMaxCard = element.getOwnedMaxCard();
        if (ownedMinCard == null && ownedMaxCard == null) {
            return String.format(SQUARE_BRACKETS_FORMAT, UNDEFINED);
        }
        String tmpMinCardValue = PropertyNamingHelper.getCardValue(ownedMinCard);
        String tmpMaxCardValue = PropertyNamingHelper.getCardValue(ownedMaxCard);
        String minCard = tmpMinCardValue.isEmpty() ? UNDEFINED : tmpMinCardValue;
        String maxCard = tmpMaxCardValue.isEmpty() ? UNDEFINED : tmpMaxCardValue;
        boolean displayNothing = false;
        boolean displayOnlyMax = false;
        if (minCard.equalsIgnoreCase(maxCard) && !minCard.isEmpty() && !maxCard.isEmpty()) {
            if (minCard.equalsIgnoreCase("1")) {
                displayNothing = true;
            } else {
                displayOnlyMax = true;
            }
        }
        if (minCard.equalsIgnoreCase("0") && maxCard.equalsIgnoreCase("*")) {
            displayOnlyMax = true;
        }
        String ownedminCardName = ownedMinCard != null ? ownedMinCard.getName() : "";
        String string = ownedmaxCardName = ownedMaxCard != null ? ownedMaxCard.getName() : "";
        if (ownedminCardName != null && !ownedminCardName.isEmpty()) {
            minCard = ownedminCardName;
            displayNothing = false;
            displayOnlyMax = false;
        }
        if (ownedmaxCardName != null && !ownedmaxCardName.isEmpty()) {
            maxCard = ownedmaxCardName;
            displayNothing = false;
            displayOnlyMax = false;
        }
        if (displayNothing) {
            return "";
        }
        if (displayOnlyMax) {
            return String.format(SQUARE_BRACKETS_FORMAT, maxCard);
        }
        return String.format(SQUARE_BRACKETS_WITH_DOTS_FORMAT, minCard, maxCard);
    }

    public static String getCardValue(NumericValue numericValue) {
        String cardValue = "";
        if (numericValue == null) {
            return "";
        }
        if (numericValue instanceof LiteralNumericValue) {
            cardValue = PropertyNamingHelper.getLiteralNumericValue((LiteralNumericValue)numericValue);
        } else if (numericValue instanceof AbstractExpressionValue) {
            cardValue = PropertyNamingHelper.getAbstractExpressionExp((AbstractExpressionValue)numericValue);
        } else if (numericValue instanceof NumericReference) {
            NumericReference ref = (NumericReference)numericValue;
            Property referencedProperty = ref.getReferencedProperty();
            if (referencedProperty != null) {
                EObject container = referencedProperty.eContainer();
                cardValue = container instanceof Class ? String.valueOf(((Class)container).getName()) + "::" + referencedProperty.getName() : referencedProperty.getName();
            } else {
                NumericValue referencedValue = ref.getReferencedValue();
                if (referencedValue != null) {
                    if (referencedValue instanceof NumericReference) {
                        cardValue = ((NumericReference)referencedValue).getName();
                    } else if (referencedValue instanceof LiteralNumericValue) {
                        cardValue = PropertyNamingHelper.getLiteralNumericValue((LiteralNumericValue)referencedValue);
                    } else if (referencedValue instanceof AbstractExpressionValue) {
                        cardValue = PropertyNamingHelper.getAbstractExpressionExp((AbstractExpressionValue)referencedValue);
                    }
                }
            }
        }
        return cardValue;
    }

    private static String getAbstractExpressionExp(AbstractExpressionValue numValue) {
        AbstractExpressionValue expValue = numValue;
        String expression = expValue.getExpression();
        String cardValue = expression != null ? expression : expValue.getName();
        return cardValue;
    }

    private static String getLiteralNumericValue(LiteralNumericValue numValue) {
        LiteralNumericValue lnv = numValue;
        String value = lnv.getValue();
        String cardValue = value != null ? value.toString() : "";
        return cardValue;
    }

    public static String prefixPropertyLabel(EObject context) {
        String str = "";
        if (context != null && context instanceof Property) {
            Property pro = (Property)context;
            if (pro.isIsPartOfKey()) {
                str = String.valueOf(str) + "&" + ' ';
            }
            if (pro.isIsStatic()) {
                str = String.valueOf(str) + "%" + ' ';
            }
        }
        return str;
    }
}

