/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.capella.ext;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IIdentifiedElement;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstanceMarker;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelEnvironment;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IPatternSupport;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.extensions.AbstractSiriusModelEnvironment;
import org.eclipse.emf.diffmerge.patterns.support.gen.commonpatternsupport.CommonPatternInstance;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;
import org.polarsys.kitalpha.patterns.emde.EmdePatternSupport;
import org.polarsys.kitalpha.patterns.emde.gen.emdepatternsupport.EmdePatternInstanceSet;
import org.polarsys.kitalpha.patterns.emde.gen.emdepatternsupport.EmdepatternsupportFactory;

public class CapellaModelEnvironment
extends AbstractSiriusModelEnvironment {
    public TransactionalEditingDomain getEditingDomain(EObject context_p) {
        TransactionalEditingDomain result = null;
        if (context_p instanceof IIdentifiedElement) {
            result = this.getCommonCatalogEditingDomain();
        } else if (context_p != null) {
            result = TransactionHelper.getEditingDomain((EObject)context_p);
        }
        return result;
    }

    public EditingDomain getEditingDomain(IFile file_p) {
        EditingDomain domain = null;
        if (file_p != null) {
            if (file_p.getFileExtension().equals("patterns")) {
                return this.getCommonCatalogEditingDomain();
            }
            domain = this.getExistingEditingDomain(file_p);
        }
        return domain;
    }

    private EditingDomain getExistingEditingDomain(IFile file_p) {
        TransactionalEditingDomain result = null;
        if (file_p != null) {
            Collection sessions = SessionManager.INSTANCE.getSessions();
            for (Session session : sessions) {
                TransactionalEditingDomain candidate = session.getTransactionalEditingDomain();
                Resource res = candidate.getResourceSet().getResource(URI.createURI((String)file_p.getFullPath().toString()), true);
                if (res == null) continue;
                result = candidate;
                break;
            }
        }
        return result;
    }

    public Resource getModelResourceFromInstanceSet(IPatternInstanceMarker context_p) {
        if (context_p instanceof EObject) {
            ResourceSet modelRSet;
            EObject set = (EObject)context_p;
            URI modelUri = set.eResource().getURI().trimFileExtension().appendFileExtension("melodymodeller");
            IModelEnvironment env = CorePatternsPlugin.getDefault().getModelEnvironment();
            TransactionalEditingDomain ed = TransactionHelper.getEditingDomain((EObject)set);
            if (env != null && ed != null && (modelRSet = ed.getResourceSet()) != null) {
                for (Resource res : modelRSet.getResources()) {
                    if (res.getURI() == null || res.getURI().toPlatformString(true) == null || !res.getURI().toString().equals(modelUri.toString())) continue;
                    return res;
                }
            }
        }
        return null;
    }

    public IPatternInstanceMarker getOrCreateInstanceSetForModelResource(Resource resource_p) {
        EmdePatternInstanceSet result = null;
        if (resource_p != null) {
            result = EmdepatternsupportFactory.eINSTANCE.createEmdePatternInstanceSet();
        }
        return result;
    }

    public boolean isAppropriatePatternSupport(IPatternSupport o) {
        return o instanceof EmdePatternSupport;
    }

    public boolean isModelResource(Resource resource_p) {
        return CapellaResourceHelper.isCapellaResource((Resource)resource_p);
    }

    public boolean isModelElement(Object object_p) {
        return object_p instanceof CommonPatternInstance || object_p instanceof ExtensibleElement;
    }
}

