/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.capella.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.extensions.DefaultSemanticMapping;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.SiriusLayersUtil;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellacore.TypedElement;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.PartitionableElement;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.pa.AbstractPhysicalComponent;

public class CapellaSemanticMapping
extends DefaultSemanticMapping {
    private static final Collection<String> DUMMY_MAPPING_NAMES = Collections.unmodifiableCollection(Arrays.asList("lab sub components", "dt_datavalue", "ca dummy"));
    private static final String PHYSICAL_COMPONENT_MAPPING_NAME = "pab_pc";
    private static final String DEPLOYMENT_MAPPING_NAME = "pab_deployment";
    private static final Collection<String> SUBCOMPONENT_MAPPING_NAMES = Collections.unmodifiableCollection(Arrays.asList("lab logical component", "pab_pc"));

    public boolean conformsToMapping(EObject semanticElt_p, AbstractNodeMapping mapping_p, boolean considerPrecondition_p, boolean considerCandidates_p, Object containerView_p) {
        boolean checkSemanticCandidates;
        boolean businessOk;
        boolean bl = businessOk = !this.isDummyMapping(mapping_p);
        if (considerPrecondition_p && considerCandidates_p && (containerView_p instanceof DDiagram || containerView_p instanceof DDiagramElementContainer)) {
            businessOk = businessOk && (!this.isSubcomponentMapping(mapping_p) || this.checkSubcomponent(SiriusLayersUtil.getSemanticElement((Object)containerView_p), semanticElt_p));
            businessOk = businessOk && (!this.isPhysicalComponentMapping(mapping_p) || !this.isDeployed(semanticElt_p));
            businessOk = businessOk && (!this.isDeploymentMapping(mapping_p) || this.checkDeployment(SiriusLayersUtil.getSemanticElement((Object)containerView_p), semanticElt_p));
        }
        boolean checkPrecondition = considerPrecondition_p && this.preconditionCanBeChecked(mapping_p);
        boolean bl2 = checkSemanticCandidates = considerCandidates_p && this.semanticCandidatesCanBeChecked(mapping_p);
        return businessOk && super.conformsToMapping(semanticElt_p, mapping_p, checkPrecondition, checkSemanticCandidates, containerView_p);
    }

    public Collection<EObject> getSemanticCandidatesForGraphicalStorage(EObject element_p, Object diagram_p) {
        Component component;
        EObject candidate1;
        Collection result = super.getSemanticCandidatesForGraphicalStorage(element_p, diagram_p);
        if (result.size() == 1 && (candidate1 = (EObject)result.iterator().next()) instanceof Component && candidate1.eContainer() instanceof ModellingArchitecture && diagram_p instanceof DDiagram && (component = (Component)candidate1).getTypedElements().size() == 1) {
            TypedElement part = (TypedElement)component.getTypedElements().get(0);
            result.add(part);
            if (this.isLAB((DDiagram)diagram_p)) {
                result.remove(candidate1);
            }
        }
        return result;
    }

    public Collection<EObject> getSemanticSelection(Object decorator_p) {
        Entity entity;
        EList typedElements;
        FOrderedSet result = new FOrderedSet();
        result.addAll(super.getSemanticSelection(decorator_p));
        EObject current = (EObject)result.iterator().next();
        if (current instanceof Part) {
            Part part = (Part)current;
            AbstractType type = part.getAbstractType();
            if (type instanceof Component) {
                result.add(type);
            }
        } else if (current instanceof Entity && (typedElements = (entity = (Entity)current).getTypedElements()).size() == 1) {
            result.add((EObject)typedElements.get(0));
        }
        return result;
    }

    public EObject getSemanticStorage(Object decorator_p) {
        DSemanticDiagram diagram;
        EObject result = super.getSemanticStorage(decorator_p);
        if (result instanceof Part) {
            result = ((Part)result).getAbstractType();
        }
        if (decorator_p instanceof DSemanticDiagram && this.diagramTargetIsExplicitlyRepresented(diagram = (DSemanticDiagram)decorator_p)) {
            if (this.isLAB((DDiagram)diagram)) {
                LogicalComponent rootLc = this.getLogicalArchitecture(diagram.getTarget()).getOwnedLogicalComponent();
                if (rootLc != null) {
                    result = rootLc;
                }
            } else {
                result = result.eContainer();
            }
        }
        return result;
    }

    private boolean checkDeployment(EObject container_p, EObject target_p) {
        boolean allowTypeDeployment = false;
        Part locationPart = null;
        AbstractPhysicalComponent locationType = null;
        if (container_p instanceof Part) {
            locationPart = (Part)container_p;
        } else if (container_p instanceof AbstractPhysicalComponent && allowTypeDeployment) {
            locationType = (AbstractPhysicalComponent)container_p;
        } else {
            return false;
        }
        Part targetPart = null;
        AbstractPhysicalComponent targetType = null;
        if (target_p instanceof Part) {
            targetPart = (Part)target_p;
        } else if (target_p instanceof AbstractPhysicalComponent && allowTypeDeployment) {
            targetType = (AbstractPhysicalComponent)target_p;
        } else {
            return false;
        }
        if (targetPart != null) {
            EList deployments = targetPart.getDeployingLinks();
            for (AbstractDeploymentLink deployment : deployments) {
                DeploymentTarget currentLocation = deployment.getLocation();
                if (currentLocation != locationPart && (!(currentLocation instanceof Part) || ((Part)currentLocation).getAbstractType() != locationType)) continue;
                return true;
            }
            return false;
        }
        if (locationPart != null) {
            EList deployments = locationPart.getDeploymentLinks();
            for (AbstractDeploymentLink deployment : deployments) {
                DeployableElement currentElement = deployment.getDeployedElement();
                if (!(currentElement instanceof Part) || ((Part)currentElement).getAbstractType() != targetType) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean checkSubcomponent(EObject container_p, EObject target_p) {
        if (!(container_p instanceof PartitionableElement) || !(target_p instanceof AbstractType) && !(target_p instanceof Part)) {
            return true;
        }
        PartitionableElement container = (PartitionableElement)container_p;
        AbstractType subComponentType = target_p instanceof Part ? ((Part)target_p).getAbstractType() : (AbstractType)target_p;
        for (Partition part : container.getOwnedPartitions()) {
            if (part.getAbstractType() != subComponentType) continue;
            return true;
        }
        return false;
    }

    private boolean diagramTargetIsExplicitlyRepresented(DSemanticDiagram diagram_p) {
        EObject diagramTarget = diagram_p.getTarget();
        if (diagramTarget == null) {
            return false;
        }
        ArrayList subNodes = new ArrayList();
        subNodes.addAll(diagram_p.getContainers());
        subNodes.addAll(diagram_p.getNodeListElements());
        subNodes.addAll(diagram_p.getNodes());
        for (AbstractDNode currentNode : subNodes) {
            if (diagramTarget != currentNode.getTarget()) continue;
            return true;
        }
        return false;
    }

    private LogicalArchitecture getLogicalArchitecture(EObject current_p) {
        if (current_p == null) {
            return null;
        }
        if (current_p instanceof LogicalArchitecture) {
            return (LogicalArchitecture)current_p;
        }
        return this.getLogicalArchitecture(current_p.eContainer());
    }

    private boolean isDeployed(EObject element_p) {
        boolean result = false;
        if (element_p instanceof DeployableElement) {
            DeployableElement deployable = (DeployableElement)element_p;
            result = !deployable.getDeployingLinks().isEmpty();
        }
        return result;
    }

    private boolean isDeploymentMapping(AbstractNodeMapping mapping_p) {
        return DEPLOYMENT_MAPPING_NAME.equals(this.getLowerCaseName(mapping_p));
    }

    private boolean isDummyMapping(AbstractNodeMapping mapping_p) {
        boolean result = false;
        if (mapping_p != null && mapping_p.getName() != null) {
            String name = mapping_p.getName().toLowerCase();
            result = DUMMY_MAPPING_NAMES.contains(name);
            result = result || name.endsWith("_dummy");
        }
        return result;
    }

    private boolean isLAB(DDiagram diagram_p) {
        boolean result = false;
        String descName = diagram_p.getDescription().getName();
        if (descName != null) {
            result = descName.toLowerCase().contains("logical architecture");
        }
        return result;
    }

    private boolean isPhysicalComponentMapping(AbstractNodeMapping mapping_p) {
        return PHYSICAL_COMPONENT_MAPPING_NAME.equals(this.getLowerCaseName(mapping_p));
    }

    private boolean isSubcomponentMapping(AbstractNodeMapping mapping_p) {
        return mapping_p != null && mapping_p.getName() != null && SUBCOMPONENT_MAPPING_NAMES.contains(this.getLowerCaseName(mapping_p));
    }

    private String getLowerCaseName(AbstractNodeMapping mapping_p) {
        String result = null;
        if (mapping_p != null && mapping_p.getName() != null) {
            result = mapping_p.getName().toLowerCase();
        }
        return result;
    }

    private boolean preconditionCanBeChecked(AbstractNodeMapping mapping_p) {
        return !this.isDeploymentMapping(mapping_p);
    }

    private boolean semanticCandidatesCanBeChecked(AbstractNodeMapping mapping_p) {
        return this.preconditionCanBeChecked(mapping_p);
    }
}

