/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.AbstractMarkerViewContentProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IViewerRefresh;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;

class CategoryContentProvider
extends AbstractMarkerViewContentProvider
implements ITreeContentProvider {
    private Map<Category, List<IMarker>> markers = new HashMap<Category, List<IMarker>>();
    private List<IMarker> ecoreMarkers = new ArrayList<IMarker>();
    private List<IMarker> messages = new ArrayList<IMarker>();

    public CategoryContentProvider(TreeViewer viewer, MarkerViewHelper helper, IViewerRefresh refresh) {
        super(viewer, helper, refresh);
        for (IMarker m : this.findMarkers()) {
            this.markerAdded(m);
        }
    }

    public synchronized Object[] getElements(Object inputElement) {
        LinkedHashSet<Object> elements = new LinkedHashSet<Object>();
        for (Category cat : this.markers.keySet()) {
            if (this.markers.get(cat).isEmpty()) continue;
            Category toplevel = cat;
            while (toplevel.getParent() != null) {
                toplevel = toplevel.getParent();
            }
            elements.add(toplevel);
        }
        elements.add(MarkerViewHelper.OTHER_CATEGORY);
        elements.addAll(this.messages);
        return elements.toArray();
    }

    public synchronized Object[] getChildren(Object parentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (parentElement instanceof Category) {
            for (Category subcategory : ((Category)parentElement).getChildren()) {
                if (!this.isVisible(subcategory)) continue;
                children.add(subcategory);
            }
            List<IMarker> ownedMarkers = this.markers.get(parentElement);
            if (ownedMarkers != null && ownedMarkers.size() > 0) {
                children.addAll(ownedMarkers);
            }
        } else if (parentElement == MarkerViewHelper.OTHER_CATEGORY) {
            children.addAll(this.ecoreMarkers);
        }
        return children.toArray();
    }

    private boolean isVisible(Category category) {
        List<IMarker> children = this.markers.get(category);
        if (children != null && children.size() > 0) {
            return true;
        }
        for (Category subcategory : category.getChildren()) {
            if (!this.isVisible(subcategory)) continue;
            return true;
        }
        return false;
    }

    public synchronized Object getParent(Object element) {
        if (element instanceof IMarker) {
            Category cat = MarkerViewHelper.getCategory((IMarker)element);
            if (cat != null) {
                return cat;
            }
            return this.viewer.getInput();
        }
        if (element instanceof Category) {
            Category parent = ((Category)element).getParent();
            if (parent != null) {
                return parent;
            }
            return this.viewer.getInput();
        }
        if (element == MarkerViewHelper.OTHER_CATEGORY) {
            return this.viewer.getInput();
        }
        return null;
    }

    public synchronized boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    private void markerAddedIntern(IMarker marker) {
        Category cat = MarkerViewHelper.getCategory(marker);
        if (cat != null) {
            List<IMarker> children = this.markers.get(cat);
            if (children == null) {
                children = new ArrayList<IMarker>();
                this.markers.put(cat, children);
            }
            children.add(marker);
        } else if (MarkerViewHelper.isEcore(marker)) {
            this.ecoreMarkers.add(marker);
        } else {
            this.messages.add(marker);
        }
        this.viewerRefresh.refresh();
    }

    @Override
    public synchronized void markerAdded(IMarker marker) {
        this.markerAddedIntern(marker);
    }

    @Override
    public synchronized void markerDeleted(IMarker marker) {
        boolean removed = false;
        if (MarkerViewHelper.isEcore(marker)) {
            this.ecoreMarkers.remove(marker);
            removed = true;
        }
        if (!removed) {
            for (Category c : this.markers.keySet()) {
                List<IMarker> children = this.markers.get(c);
                if (children != null && (removed = children.remove(marker))) break;
            }
        }
        if (!removed) {
            removed = this.messages.remove(marker);
        }
        if (removed) {
            this.viewerRefresh.refresh();
        }
    }
}

