/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.AbstractMarkerViewContentProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IViewerRefresh;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;

public class PreferenceRuleSetLabelProvider
extends AbstractMarkerViewContentProvider
implements ITreeContentProvider {
    private Map<Object, List<IMarker>> markers;
    private List<IMarker> messages;

    public PreferenceRuleSetLabelProvider(TreeViewer viewer, MarkerViewHelper helper, IViewerRefresh refresh) {
        super(viewer, helper, refresh);
        this.refillCache();
    }

    private void refillCache() {
        this.markers = new LinkedHashMap<Object, List<IMarker>>();
        this.messages = new ArrayList<IMarker>();
        for (IMarker marker : this.findMarkers()) {
            this.markerAddedIntern(marker);
        }
    }

    private Object findKey(IMarker marker) {
        Diagnostic d;
        Object key = MarkerViewHelper.getConstraintDescriptor(marker);
        if (key == null && (d = MarkerViewHelper.getDiagnostic(marker)) != null) {
            key = MarkerViewHelper.OTHER_RULES;
        }
        return key;
    }

    public Object getParent(Object element) {
        Diagnostic d;
        Object parent = null;
        if (element instanceof IMarker && (parent = MarkerViewHelper.getConstraintDescriptor((IMarker)element)) == null && (d = MarkerViewHelper.getDiagnostic((IMarker)element)) != null) {
            parent = MarkerViewHelper.OTHER_RULES;
        }
        return parent;
    }

    public synchronized Object[] getElements(Object inputElement) {
        Object[] elems = new Object[this.markers.size() + this.messages.size()];
        int i = 0;
        Set<Object> keys = this.markers.keySet();
        for (Object object : keys) {
            elems[i++] = object;
        }
        for (Object object : this.messages) {
            elems[i++] = object;
        }
        return elems;
    }

    public synchronized Object[] getChildren(Object parentElement) {
        List<IMarker> children = this.markers.get(parentElement);
        if (children != null) {
            return children.toArray();
        }
        return this.noChildren;
    }

    public synchronized boolean hasChildren(Object element) {
        if (element == this.viewer.getInput()) {
            Set<Object> keys = this.markers.keySet();
            for (Object key : keys) {
                List<IMarker> children = this.markers.get(key);
                if (children == null || children.size() <= 0) continue;
                return true;
            }
            return !this.messages.isEmpty();
        }
        List<IMarker> children = this.markers.get(element);
        return children != null && children.size() > 0;
    }

    private void markerAddedIntern(IMarker marker) {
        Object key = this.findKey(marker);
        if (key != null) {
            List<IMarker> markersForKey = this.markers.get(key);
            if (markersForKey == null) {
                markersForKey = new ArrayList<IMarker>();
                this.markers.put(key, markersForKey);
            }
            markersForKey.add(marker);
        } else {
            this.messages.add(marker);
        }
        this.viewerRefresh.refresh();
    }

    @Override
    public synchronized void markerAdded(IMarker marker) {
        this.markerAddedIntern(marker);
    }

    @Override
    public synchronized void markerDeleted(IMarker marker) {
        boolean removed = false;
        for (Object key : this.markers.keySet()) {
            List<IMarker> children = this.markers.get(key);
            if (children != null && (removed = children.remove(marker))) break;
        }
        if (!removed) {
            this.messages.remove(marker);
        }
        this.viewerRefresh.refresh();
    }
}

