/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IViewerRefresh;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerView;

class ViewerRefresh
implements Runnable,
IViewerRefresh {
    private final ScheduledExecutorService scheduler;
    private ScheduledFuture<?> future;
    protected boolean reschedule;
    protected final MarkerView view;
    protected final long delay;
    protected final TimeUnit timeunit;

    ViewerRefresh(ScheduledExecutorService service, MarkerView view, long delay, TimeUnit timeunit) {
        this.scheduler = service;
        this.view = view;
        this.delay = delay;
        this.timeunit = timeunit;
    }

    ViewerRefresh(MarkerView view, long delay, TimeUnit timeunit) {
        this(Executors.newScheduledThreadPool(1), view, delay, timeunit);
    }

    @Override
    public synchronized void refresh() {
        if (this.future == null || this.future.isDone()) {
            this.reschedule = false;
            this.future = this.scheduler.schedule(this, this.delay, TimeUnit.MILLISECONDS);
        } else {
            this.reschedule = true;
        }
    }

    @Override
    public synchronized void run() {
        if (this.reschedule) {
            this.reschedule = false;
            this.future = this.scheduler.schedule(this, this.delay, TimeUnit.MILLISECONDS);
        } else {
            Display d = PlatformUI.getWorkbench().getDisplay();
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ViewerRefresh.this.view != null && !(this).ViewerRefresh.this.view.getViewer().getTree().isDisposed()) {
                                try {
                                    (this).ViewerRefresh.this.view.getViewer().getTree().setRedraw(false);
                                    (this).ViewerRefresh.this.view.getViewer().refresh();
                                }
                                finally {
                                    (this).ViewerRefresh.this.view.getViewer().getTree().setRedraw(true);
                                }
                            }
                        }
                    });
                }
            });
        }
    }
}

