/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.LightMarkerRegistry;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerView;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.Messages;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.handler.QuickfixHandler;

public class QuickFixAllConstraintMarkersHandler
extends QuickfixHandler {
    private final String menuId = "org.polarsys.capella.core.validation.quickfixAllSimilar";
    private final String menuImage = "quickfixAll-repository.png";

    public static IMarkerHelpRegistry getMarkerRegistry() {
        return IDE.getMarkerHelpRegistry();
    }

    @Override
    protected IContributionItem[] getContributionItems() {
        List<IMarker> selection = this.getSelectedMarkers();
        if (selection.isEmpty()) {
            return NO_CONTRIBUTION_ITEM;
        }
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        IConstraintDescriptor selectedMarkerDesc = MarkerViewHelper.getConstraintDescriptor(selection.get(0));
        if (selectedMarkerDesc != null) {
            ArrayList<IMarker> sameConstraintMarkers = new ArrayList<IMarker>();
            Collection<IMarker> allMarkers = LightMarkerRegistry.getInstance().getMarkers();
            for (IMarker marker : allMarkers) {
                if (MarkerViewHelper.getConstraintDescriptor(marker) != selectedMarkerDesc) continue;
                sameConstraintMarkers.add(marker);
            }
            if (sameConstraintMarkers.size() <= 1) {
                return NO_CONTRIBUTION_ITEM;
            }
            IMarkerResolution[] iMarkerResolutionArray = QuickFixAllConstraintMarkersHandler.getMarkerRegistry().getResolutions(selection.get(0));
            int n = iMarkerResolutionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerResolution res = iMarkerResolutionArray[n2];
                HashSet<IMarker> markersToFix = new HashSet<IMarker>();
                if (res instanceof WorkbenchMarkerResolution) {
                    IMarker[] otherMarkers;
                    IMarker[] iMarkerArray = otherMarkers = ((WorkbenchMarkerResolution)res).findOtherMarkers(sameConstraintMarkers.toArray(new IMarker[0]));
                    int n3 = otherMarkers.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMarker otherMarker = iMarkerArray[n4];
                        markersToFix.add(otherMarker);
                        ++n4;
                    }
                }
                if (markersToFix.size() > 1 && this.isInQuickFixAllSimilar(res, markersToFix)) {
                    items.add(this.createContributionItem(markersToFix, res));
                }
                ++n2;
            }
        }
        if (items.size() > 0) {
            ImageDescriptor image = MarkerViewPlugin.getDefault().getImageDescriptor("quickfixAll-repository.png");
            String text = Messages.MarkerView_QuickfixAll_Command_Name;
            MenuManager manager = new MenuManager(text, image, "org.polarsys.capella.core.validation.quickfixAllSimilar");
            for (IContributionItem item : items) {
                manager.add(item);
            }
            return new IContributionItem[]{manager};
        }
        return NO_CONTRIBUTION_ITEM;
    }

    @Override
    protected List<IMarker> getSelectedMarkers() {
        MarkerView view;
        ISelection selection;
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart instanceof MarkerView && (selection = (view = (MarkerView)activePart).getViewer().getSelection()) instanceof StructuredSelection && ((StructuredSelection)selection).size() > 0) {
            for (Object element : (StructuredSelection)selection) {
                if (!(element instanceof IMarker)) continue;
                result.add((IMarker)element);
            }
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

