/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.flexibility.wizards.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.polarsys.capella.common.flexibility.properties.PropertyChangeListener;
import org.polarsys.capella.common.flexibility.properties.PropertyChangedEvent;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.ui.PropertyControl;
import org.polarsys.capella.core.commands.preferences.service.AbstractDefaultPreferencePage;
import org.polarsys.capella.core.commands.preferences.service.UserProfileModeEnum;

public abstract class CapellaPropertyPreferencePage
extends AbstractDefaultPreferencePage
implements PropertyChangeListener,
IWorkbenchPreferencePage {
    public CapellaPropertyPreferencePage(String propertyPageId_p) {
        super(propertyPageId_p);
    }

    public abstract IPropertyContext getContext();

    public abstract IRendererContext getRendererContext();

    public void init(IWorkbench workbench_p) {
        IPropertyContext context = this.getContext();
        if (context != null) {
            context.registerListener((PropertyChangeListener)this);
        }
    }

    protected ILabelProvider getLabelProvider() {
        return this.getRendererContext().getLabelProvider();
    }

    protected void performApply() {
        super.performApply();
        IPropertyContext context = this.getContext();
        if (context != null) {
            context.writeAll();
        }
    }

    public boolean performOk() {
        IPropertyContext context = this.getContext();
        if (context != null) {
            context.writeAll();
        }
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        IPropertyContext context = this.getContext();
        if (context != null) {
            context.setDefaults();
        }
    }

    protected Control createContents(Composite parent_p) {
        ILabelProvider labelProvider = this.getLabelProvider();
        PropertyControl control = new PropertyControl(labelProvider, this.getContext(), this.getRendererContext()){

            protected boolean isFlat() {
                return true;
            }
        };
        Control composite = control.createControl(parent_p);
        this.setEnable((Composite)composite, UserProfileModeEnum.Expert);
        return composite;
    }

    protected void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        if (message == null || message.length() == 0) {
            this.setErrorMessage(null);
            this.setMessage(this.getDescription());
        } else {
            switch (status.getSeverity()) {
                case 0: {
                    this.setErrorMessage(null);
                    this.setMessage(this.getDescription());
                    break;
                }
                case 2: {
                    this.setErrorMessage(null);
                    this.setMessage(message, 2);
                    break;
                }
                case 1: {
                    this.setErrorMessage(null);
                    this.setMessage(message, 1);
                    break;
                }
                default: {
                    this.setErrorMessage(null);
                    this.setMessage(message, 3);
                }
            }
        }
    }

    protected IStatus findMostSevere() {
        IProperties properties;
        IPropertyContext context = this.getContext();
        if (context != null && (properties = context.getProperties()) != null) {
            for (IProperty item : properties.getAllItems()) {
                IStatus status = item.validate(context.getCurrentValue(item), context);
                if (status.isOK()) continue;
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    public void update(PropertyChangedEvent event_p) {
        this.applyToStatusLine(this.findMostSevere());
    }
}

