/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.dialogs;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.ad.common.AD_Log;

public class EditorHelper {
    public static void setSelectionToViewer(IEditorPart part, List<EObject> eObjects) {
        if (eObjects == null || eObjects.size() == 0) {
            return;
        }
        try {
            Class[] types = new Class[]{Class.forName("java.util.Collection")};
            Method method = part.getClass().getMethod("setSelectionToViewer", types);
            if (method != null) {
                Object[] params = new Object[]{eObjects};
                method.invoke((Object)part, params);
            }
        }
        catch (Throwable t) {
            AD_Log.getDefault().logError(t);
        }
    }

    public static void setSelectionToViewer(IEditorPart part, URI uri) {
        if (uri == null || !uri.hasFragment()) {
            return;
        }
        if (part == null || !(part instanceof IEditingDomainProvider)) {
            return;
        }
        EditingDomain editingDomain = ((IEditingDomainProvider)part).getEditingDomain();
        EObject eObject = editingDomain.getResourceSet().getEObject(uri, true);
        if (eObject == null) {
            return;
        }
        try {
            Class[] types = new Class[]{Class.forName("java.util.Collection")};
            Method method = part.getClass().getMethod("setSelectionToViewer", types);
            if (method != null) {
                Object[] params = new Object[]{Collections.singletonList(eObject)};
                method.invoke((Object)part, params);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void openEditorsAndSelect(Map<Resource, List<EObject>> resources) {
        if (resources.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Resource, List<EObject>>> it = resources.entrySet().iterator();
        while (it.hasNext()) {
            try {
                IEditorPart editorPart;
                URIConverter converter;
                Map.Entry<Resource, List<EObject>> entry = it.next();
                Resource resource = entry.getKey();
                URI uri = resource.getURI();
                if (uri != null && resource.getResourceSet() != null && (converter = resource.getResourceSet().getURIConverter()) != null) {
                    uri = converter.normalize(uri);
                }
                if ((editorPart = EditorHelper.openEditor(uri)) == null) continue;
                EditorHelper.setSelectionToViewer(editorPart, entry.getValue());
            }
            catch (Throwable t) {
                AD_Log.getDefault().logError(t);
            }
        }
    }

    public static String computeEditorId(String fileName) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(fileName);
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    public static IEditorInput getEditorInput(URI uri) {
        if (uri == null || uri.isEmpty() || "//#".equals(uri)) {
            return null;
        }
        if (uri.isPlatformResource()) {
            String path = uri.toPlatformString(true);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
            if (resource instanceof IFile) {
                return EclipseUtil.createFileEditorInput((IFile)resource);
            }
        }
        return new URIEditorInput(uri.trimFragment());
    }

    public static IEditorPart openEditor(URI uri) throws PartInitException {
        if (uri == null) {
            return null;
        }
        IEditorPart part = EditorHelper.restoreAlreadyOpenedEditor(uri, null, true);
        if (part != null) {
            return part;
        }
        IURIEditorInput editorInput = null;
        if (uri.isPlatformResource()) {
            String path = uri.toPlatformString(true);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
            if (resource instanceof IFile) {
                editorInput = EclipseUtil.createFileEditorInput((IFile)resource);
                return EditorHelper.openEditor((IEditorInput)editorInput, URI.createPlatformPluginURI((String)resource.getFullPath().toString(), (boolean)false));
            }
        }
        return EditorHelper.openEditor((IEditorInput)new URIEditorInput(uri.trimFragment()), uri);
    }

    public static IEditorPart openEditor(URI uri, String editorId) throws PartInitException {
        if (uri == null) {
            return null;
        }
        IEditorPart part = EditorHelper.restoreAlreadyOpenedEditor(uri, editorId, true);
        if (part != null) {
            return part;
        }
        IURIEditorInput editorInput = null;
        if (uri.isPlatformResource()) {
            String path = uri.toPlatformString(true);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
            if (resource instanceof IFile) {
                editorInput = EclipseUtil.createFileEditorInput((IFile)resource);
                return EditorHelper.openEditor((IEditorInput)editorInput, URI.createPlatformPluginURI((String)resource.getFullPath().toString(), (boolean)false), editorId);
            }
        }
        return EditorHelper.openEditor((IEditorInput)new URIEditorInput(uri.trimFragment()), uri, editorId);
    }

    public static IEditorPart openEditor(IEditorInput input, URI uri) throws PartInitException {
        return EditorHelper.openEditor(input, uri, null);
    }

    public static IEditorPart openEditor(IEditorInput input, URI uri, String editorId) throws PartInitException {
        if (input == null || uri == null) {
            return null;
        }
        IEditorPart part = EditorHelper.restoreAlreadyOpenedEditor(uri, editorId, true);
        if (part != null) {
            return part;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        return page.openEditor(input, editorId != null ? editorId : EditorHelper.computeEditorId(uri.trimFragment().lastSegment()), true, 0);
    }

    public static boolean isAlreadyOpenedEditor(URI uri) {
        if (uri == null) {
            return false;
        }
        return EditorHelper.restoreAlreadyOpenedEditor(uri, null, false) != null;
    }

    private static IEditorPart restoreAlreadyOpenedEditor(URI uri, String editorId, boolean activate) {
        if (uri == null) {
            return null;
        }
        URI uriToCheck = uri.trimFragment();
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage innerPage = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = innerPage.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference reference = iEditorReferenceArray[n6];
                    try {
                        URI editorInputURI;
                        IEditorInput editorInput = reference.getEditorInput();
                        if (editorInput != null && (editorInputURI = EditorHelper.getURI(editorInput)) != null && editorInputURI.equals(uriToCheck)) {
                            IEditorPart part = reference.getEditor(true);
                            if (editorId == null || editorId.equals(part.getEditorSite().getId())) {
                                if (activate) {
                                    window.setActivePage(innerPage);
                                    innerPage.activate((IWorkbenchPart)part);
                                    part.setFocus();
                                }
                                return part;
                            }
                        }
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static URI getURI(IEditorInput editorInput) {
        URI result = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            result = EclipseUtil.getURI(editorInput);
        }
        if (result == null) {
            result = editorInput instanceof URIEditorInput ? ((URIEditorInput)editorInput).getURI().trimFragment() : URI.createURI((String)editorInput.getName());
        }
        return result;
    }

    public static class EclipseUtil {
        static final Class<?> FILE_CLASS;
        static final Class<?> FILE_REVISION_CLASS;
        static final Method FILE_REVISION_GET_URI_METHOD;
        static final Class<?> URI_EDITOR_INPUT_CLASS;

        static {
            Class<IFile> fileClass = null;
            try {
                fileClass = IFile.class;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            FILE_CLASS = fileClass;
            Class fileRevisionClass = null;
            Method fileRevisionGetURIMethod = null;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.team.core");
            if (bundle != null && (bundle.getState() & 0x2C) != 0) {
                try {
                    fileRevisionClass = bundle.loadClass("org.eclipse.team.core.history.IFileRevision");
                    fileRevisionGetURIMethod = fileRevisionClass.getMethod("getURI", new Class[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            FILE_REVISION_CLASS = fileRevisionClass;
            FILE_REVISION_GET_URI_METHOD = fileRevisionGetURIMethod;
            Class<IURIEditorInput> uriEditorInputClass = null;
            try {
                uriEditorInputClass = IURIEditorInput.class;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            URI_EDITOR_INPUT_CLASS = uriEditorInputClass;
        }

        public static URI getURI(IEditorInput editorInput) {
            Object fileRevision;
            IFile file;
            if (FILE_CLASS != null && (file = EclipseUtil.getIFile(editorInput)) != null) {
                return URI.createPlatformPluginURI((String)file.getFullPath().toString(), (boolean)false);
            }
            if (FILE_REVISION_CLASS != null && (fileRevision = editorInput.getAdapter(FILE_REVISION_CLASS)) != null) {
                try {
                    return URI.createURI((String)((java.net.URI)FILE_REVISION_GET_URI_METHOD.invoke(fileRevision, new Object[0])).toString());
                }
                catch (Throwable t) {
                    AD_Log.getDefault().logError(t);
                }
            }
            if (URI_EDITOR_INPUT_CLASS != null && editorInput instanceof IURIEditorInput) {
                return URI.createURI((String)((IURIEditorInput)editorInput).getURI().toString()).trimFragment();
            }
            return null;
        }

        public static IFile getIFile(IEditorInput editorInput) {
            if (FILE_CLASS != null) {
                return (IFile)editorInput.getAdapter(FILE_CLASS);
            }
            return null;
        }

        public static IURIEditorInput createFileEditorInput(IFile file) {
            return new FileEditorInput(file);
        }
    }
}

