/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.dialogs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.model.edit.helpers.ModelHelper;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.ui.Messages;

public class ModelFileDialog
extends TitleAreaDialog {
    private ListViewer viewer;
    private final List<URI> result = new ArrayList<URI>();
    private final String filePattern;
    private Viewpoint viewpoint;

    public ModelFileDialog(Shell shell, Viewpoint viewpoint, String filePattern) {
        super(shell);
        this.viewpoint = viewpoint;
        this.filePattern = filePattern;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        this.createWidgets(contents);
        this.init();
        Dialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    public void init() {
        this.viewer.setInput((Object)ModelHelper.getCandidateURIs((EObject)this.viewpoint, (String)this.filePattern));
    }

    private void collectFileInPlatform(List<Bundle> pBundles, List<URI> fileUris) {
        for (Bundle bundle : pBundles) {
            Enumeration e = bundle.findEntries(".", this.filePattern, true);
            while (e != null && e.hasMoreElements()) {
                URL url = (URL)e.nextElement();
                String path = url.getPath();
                URI uri = URI.createPlatformPluginURI((String)(String.valueOf(bundle.getSymbolicName()) + path.substring(2)), (boolean)true);
                fileUris.add(uri);
            }
        }
    }

    private void collectFileInWorkspace(List<IProject> wsProjects, final List<URI> fileUris) {
        String[] fileNamePattern = new String[]{this.filePattern};
        FileTextSearchScope fScope = FileTextSearchScope.newSearchScope((IResource[])wsProjects.toArray(new IResource[wsProjects.size()]), (String[])fileNamePattern, (boolean)true);
        TextSearchRequestor requestor = new TextSearchRequestor(){

            public boolean acceptFile(IFile file) throws CoreException {
                URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toPortableString(), (boolean)true);
                fileUris.add(uri);
                return super.acceptFile(file);
            }
        };
        Pattern searchPattern = Pattern.compile("");
        TextSearchEngine.create().search((TextSearchScope)fScope, requestor, searchPattern, null);
    }

    private void collectBundles(IPluginModelBase model, List<IProject> wsProjects, List<Bundle> pBundles, Set<String> visited) {
        String symbolicName = model.getBundleDescription().getSymbolicName();
        IResource underlyingResource = model.getUnderlyingResource();
        if (underlyingResource != null) {
            wsProjects.add(underlyingResource.getProject());
        } else {
            Bundle bundle = Platform.getBundle((String)symbolicName);
            pBundles.add(bundle);
        }
        visited.add(symbolicName);
        BundleDescription description = model.getBundleDescription();
        BundleSpecification[] bundleSpecificationArray = description.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification req = bundleSpecificationArray[n2];
            if (req.getSupplier() == null) {
                AD_Log.getDefault().logWarning(NLS.bind((String)Messages.LoadModelDialog_error2, (Object)req.hashCode()));
            } else {
                IPluginModelBase reqModel = PluginRegistry.findModel((BundleDescription)req.getSupplier().getSupplier());
                symbolicName = reqModel.getBundleDescription().getSymbolicName();
                if (!visited.contains(symbolicName)) {
                    this.collectBundles(reqModel, wsProjects, pBundles, visited);
                }
            }
            ++n2;
        }
    }

    public void collectDependenciesInWorkspace(IPluginModelBase model, Set<String> wsModels, List<IResource> collector) {
        IResource underlyingResource = model.getUnderlyingResource();
        if (underlyingResource != null) {
            collector.add((IResource)underlyingResource.getProject());
        }
        BundleDescription description = model.getBundleDescription();
        BundleSpecification[] bundleSpecificationArray = description.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification req = bundleSpecificationArray[n2];
            if (req.getSupplier() == null) {
                AD_Log.getDefault().logWarning(NLS.bind((String)Messages.LoadModelDialog_error2, (Object)req.hashCode()));
            } else {
                IPluginModelBase reqModel = PluginRegistry.findModel((BundleDescription)req.getSupplier().getSupplier());
                String symbolicName = reqModel.getBundleDescription().getSymbolicName();
                if (wsModels.contains(symbolicName)) {
                    this.collectDependenciesInWorkspace(reqModel, wsModels, collector);
                }
            }
            ++n2;
        }
    }

    public Set<String> computeWorkspaceModels() {
        HashSet<String> result = new HashSet<String>();
        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            result.add(model.getBundleDescription().getSymbolicName());
            ++n2;
        }
        return result;
    }

    private void createWidgets(Composite parent) {
        this.viewer = new ListViewer(parent);
        this.viewer.getList().setLayoutData((Object)new GridData(1808));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelFileDialog.this.getButton(0).setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModelFileDialog.this.okPressed();
            }
        });
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.Dialog_Add_label, true).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private Composite createComposite(Composite parentComposite) {
        Composite contents = new Composite(parentComposite, 0);
        contents.setLayout((Layout)new GridLayout(1, false));
        contents.setLayoutData((Object)new GridData(1808));
        this.setTitle(Messages.LoadModelDialog_title);
        this.setMessage(Messages.LoadModelDialog_description);
        return contents;
    }

    protected void okPressed() {
        IStructuredSelection ss = (IStructuredSelection)this.viewer.getSelection();
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.result.add((URI)obj);
            ++n2;
        }
        super.okPressed();
    }

    public List<URI> getResult() {
        return this.result;
    }
}

