/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.polarsys.kitalpha.ad.viewpoint.ui.provider.AFSelectionProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.ViewpointView;

public class DefaultSelectionProvider
implements AFSelectionProvider {
    protected final List<Object> selectedObjects = new ArrayList<Object>();
    private final List<ISelectionListener> listeners = new ArrayList<ISelectionListener>();
    private final ISelectionListener listener;

    public DefaultSelectionProvider() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        this.listener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part instanceof ViewpointView) {
                    return;
                }
                DefaultSelectionProvider.this.selectedObjects.clear();
                if (selection instanceof IStructuredSelection) {
                    Object[] objectArray = ((IStructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        DefaultSelectionProvider.this.selectedObjects.add(obj);
                        ++n2;
                    }
                }
                for (ISelectionListener listener : DefaultSelectionProvider.this.listeners) {
                    listener.selectionChanged(part, selection);
                }
            }
        };
        selectionService.addSelectionListener(this.listener);
        IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
        this.listener.selectionChanged(activePart, selectionService.getSelection());
    }

    @Override
    public List<Object> getSelection() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : this.selectedObjects) {
            if (!(obj instanceof EObject)) continue;
            result.add(obj);
        }
        return result;
    }

    @Override
    public void addListener(ISelectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ISelectionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void dispose() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        selectionService.removeSelectionListener(this.listener);
    }
}

