/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.ViewElement;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.ViewHelper;
import org.polarsys.kitalpha.resourcereuse.model.Location;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

final class OpenViewAction
extends Action
implements IMenuCreator {
    private Resource resource;
    private List<ViewElement> viewIds = new ArrayList<ViewElement>();
    private SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent ee) {
            try {
                MenuItem menuItem = (MenuItem)ee.getSource();
                String viewId = (String)menuItem.getData();
                OpenViewAction.this.showView(viewId);
            }
            catch (Exception e) {
                AD_Log.getDefault().logError((Throwable)e);
            }
        }
    };

    public OpenViewAction() {
        super("", 4);
        this.setMenuCreator(this);
    }

    public void run() {
        try {
            for (ViewElement id : this.viewIds) {
                this.showView(id.getId());
            }
        }
        catch (Exception e) {
            AD_Log.getDefault().logError((Throwable)e);
        }
    }

    public void setResource(Resource resource) {
        if (this.resource == resource) {
            return;
        }
        this.resource = resource;
        this.setEnabled(resource != null && resource.getProviderLocation() != Location.WORSPACE);
        this.viewIds.clear();
        if (resource == null) {
            return;
        }
        this.viewIds = ViewHelper.getViewIds(resource);
    }

    public void dispose() {
    }

    private void fillMenu(Menu menu) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem mi = menuItemArray[n2];
            mi.dispose();
            ++n2;
        }
        for (ViewElement view : this.viewIds) {
            MenuItem mi = new MenuItem(menu, 8);
            mi.setText(view.getName());
            mi.setData((Object)view);
            mi.addSelectionListener(this.listener);
        }
    }

    public Menu getMenu(Control parent) {
        Menu dynamicMenu = new Menu(parent);
        dynamicMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                OpenViewAction.this.fillMenu((Menu)e.getSource());
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        return dynamicMenu;
    }

    public Menu getMenu(Menu parent) {
        Menu dynamicMenu = new Menu(parent);
        dynamicMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                OpenViewAction.this.fillMenu((Menu)e.getSource());
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        return dynamicMenu;
    }

    public void showView(String viewId) throws PartInitException {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        activePage.showView(viewId);
    }
}

