/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.ui.IFileEditorInput;

public class IEditorInputTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Boolean actual = Boolean.FALSE;
        if (property.equals("isManaged")) {
            if (receiver instanceof IFileEditorInput) {
                IFileEditorInput input = (IFileEditorInput)receiver;
                IFile file = input.getFile();
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)file);
                try {
                    actual = new Boolean(cvsResource != null && !cvsResource.isFolder() && cvsResource.isManaged());
                }
                catch (CVSException e) {
                    actual = new Boolean(this.isEnabledForException((TeamException)((Object)e)));
                }
                return actual.equals(expectedValue);
            }
            return false;
        }
        return false;
    }

    protected boolean isEnabledForException(TeamException exception) {
        if (exception.getStatus().getCode() == 274) {
            return true;
        }
        TeamPlugin.log((CoreException)exception);
        return false;
    }
}

