/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.ui.PlatformUI;

public class SingleFolderTagSource
extends TagSource {
    private ICVSFolder folder;

    public static CVSTag[] getTags(ICVSFolder folder, int type) {
        if (type == 0) {
            return new CVSTag[]{CVSTag.DEFAULT};
        }
        return CVSUIPlugin.getPlugin().getRepositoryManager().getKnownTags(folder, type);
    }

    SingleFolderTagSource(ICVSFolder folder) {
        this.folder = folder;
    }

    public CVSTag[] getTags(int type) {
        if (type == 0 || type == -1) {
            return super.getTags(type);
        }
        return SingleFolderTagSource.getTags(this.getFolder(), type);
    }

    public ICVSFolder getFolder() {
        return this.folder;
    }

    public CVSTag[] refresh(boolean bestEffort, IProgressMonitor monitor) throws TeamException {
        CVSTag[] tags = CVSUIPlugin.getPlugin().getRepositoryManager().refreshDefinedTags(this.getFolder(), bestEffort, true, monitor);
        this.fireChange();
        return tags;
    }

    public ICVSRepositoryLocation getLocation() {
        RepositoryManager mgr = CVSUIPlugin.getPlugin().getRepositoryManager();
        ICVSRepositoryLocation location = mgr.getRepositoryLocationFor((ICVSResource)this.getFolder());
        return location;
    }

    public String getShortDescription() {
        return this.getFolder().getName();
    }

    public void commit(final CVSTag[] tags, final boolean replace, IProgressMonitor monitor) throws CVSException {
        try {
            final RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
            manager.run(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ICVSFolder folder = SingleFolderTagSource.this.getFolder();
                        if (replace) {
                            CVSTag[] oldTags = manager.getKnownTags(folder);
                            manager.removeTags(folder, oldTags);
                        }
                        manager.addTags((ICVSResource)folder, tags);
                    }
                    catch (CVSException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, monitor);
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {}
        this.fireChange();
    }

    public ICVSResource[] getCVSResources() {
        final ICVSResource[][] resources = new ICVSResource[1][];
        try {
            this.getRunnableContext().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            resources[0] = SingleFolderTagSource.this.folder.fetchChildren(monitor);
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return resources[0];
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.log((CoreException)((Object)CVSException.wrapException((Exception)e)));
        }
        catch (InterruptedException interruptedException) {}
        return new ICVSResource[]{this.folder};
    }

    private IRunnableContext getRunnableContext() {
        return PlatformUI.getWorkbench().getProgressService();
    }
}

