/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.wizards.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationTreeViewer;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.LinkManager;
import org.polarsys.capella.core.ui.toolkit.viewers.CapellaElementLabelProvider;
import org.polarsys.capella.core.validation.CapellaValidationActivator;
import org.polarsys.capella.core.validation.utils.ValidationHelper;

public class EIAllocationLabelProvider
extends CapellaElementLabelProvider
implements IBaseLabelProvider,
IColorProvider,
IFontProvider {
    protected final boolean _isSourceViewer;
    private final EIAllocationTreeViewer _treeViewer;
    private LinkManager _linkManager;
    private Font _startedLinkElementFont;
    private IConstraintFilter _filter = new IConstraintFilter(){

        public boolean accept(IConstraintDescriptor constraint_p, EObject target_p) {
            return EIAllocationLabelProvider.this._isSourceViewer ? EIAllocationLabelProvider.this._srcDesc.contains(constraint_p) : EIAllocationLabelProvider.this._tgtDesc.contains(constraint_p);
        }
    };
    private static final String prefix = "org.polarsys.capella.core.data.fa.validation.";
    protected List<IConstraintDescriptor> _srcDesc = EIAllocationLabelProvider.getConstraintDescriptors(Arrays.asList("org.polarsys.capella.core.data.fa.validation.TC_DF_10", "org.polarsys.capella.core.data.fa.validation.TC_DF_11", "org.polarsys.capella.core.data.fa.validation.TC_DF_12", "org.polarsys.capella.core.data.fa.validation.TC_DF_13", "org.polarsys.capella.core.data.fa.validation.TC_DF_14"));
    protected List<IConstraintDescriptor> _tgtDesc = EIAllocationLabelProvider.getConstraintDescriptors(Arrays.asList("org.polarsys.capella.core.data.fa.validation.TC_DF_11", "org.polarsys.capella.core.data.fa.validation.TC_DF_12", "org.polarsys.capella.core.data.fa.validation.TC_DF_13", "org.polarsys.capella.core.data.fa.validation.TC_DF_14"));
    public static final String VALIDATION_KEY = "Validation";

    public EIAllocationLabelProvider(LinkManager linkManager_p, EIAllocationTreeViewer treeViewer_p, boolean isSourceViewer_p) {
        this._isSourceViewer = isSourceViewer_p;
        this._treeViewer = treeViewer_p;
        this._linkManager = linkManager_p;
    }

    public void dispose() {
        if (this._startedLinkElementFont != null && !this._startedLinkElementFont.isDisposed()) {
            this._startedLinkElementFont.dispose();
            this._startedLinkElementFont = null;
        }
        super.dispose();
    }

    public String getText(Object element_p) {
        String text = super.getText(element_p);
        if (this._linkManager.isStartedElement(element_p)) {
            text = String.valueOf(text) + " [start link]";
        }
        return text;
    }

    public Font getFont(Object element_p) {
        if (this._linkManager.isStartedElement(element_p)) {
            return this.getStartedLinkElementFont();
        }
        return super.getFont(element_p);
    }

    private boolean isValid(EObject element_p) {
        CapellaValidationActivator.getDefault().getCapellaValidatorAdapter().getValidator().addConstraintFilter(this._filter);
        IStatus status = CapellaValidationActivator.getDefault().getCapellaValidatorAdapter().getValidator().validate(element_p);
        CapellaValidationActivator.getDefault().getCapellaValidatorAdapter().getValidator().removeConstraintFilter(this._filter);
        Widget w = this._treeViewer.findItem(element_p);
        if (w instanceof TreeItem) {
            if (!status.isOK()) {
                w.setData(VALIDATION_KEY, (Object)status);
            } else {
                w.setData(VALIDATION_KEY, null);
            }
        }
        return status.isOK();
    }

    public Color getForeground(Object element_p) {
        if (!this.isValid((EObject)element_p)) {
            return Display.getCurrent().getSystemColor(3);
        }
        return super.getForeground(element_p);
    }

    public static List<IConstraintDescriptor> getConstraintDescriptors(List<String> ids_p) {
        ArrayList<IConstraintDescriptor> result = new ArrayList<IConstraintDescriptor>();
        ValidationHelper.ensureEMFValidationActivation();
        for (IConstraintDescriptor icd : ValidationHelper.getAllCapellaConstraintDescriptors()) {
            String id = icd.getId();
            if (!ids_p.contains(id)) continue;
            result.add(icd);
        }
        return result;
    }

    protected Font getStartedLinkElementFont() {
        if (this._startedLinkElementFont == null) {
            this._startedLinkElementFont = new Font((Device)Display.getDefault(), "Arial", 9, 3);
        }
        return this._startedLinkElementFont;
    }
}

