/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.wizards.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortRealization;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;

public class EIAllocationModelHelpers {
    public static List<ModelElement> getTransitionedElements(ModelElement element_p) {
        return EIAllocationModelHelpers.getTransitionedElements(Collections.singletonList(element_p));
    }

    public static List<ModelElement> getTransitionedElements(List<ModelElement> elements_p) {
        ArrayList<ModelElement> result = new ArrayList<ModelElement>();
        for (ModelElement elt : elements_p) {
            if (elt instanceof AbstractFunction) {
                for (AbstractTrace trace : ((AbstractFunction)elt).getIncomingTraces()) {
                    AbstractFunction fct;
                    if (!(trace instanceof FunctionRealization) || (fct = ((FunctionRealization)trace).getAllocatingFunction()) == null) continue;
                    result.add((ModelElement)fct);
                }
                continue;
            }
            if (!(elt instanceof FunctionPort)) continue;
            for (AbstractTrace trace : ((FunctionPort)elt).getIncomingTraces()) {
                Port port;
                if (!(trace instanceof PortRealization) || (port = ((PortRealization)trace).getRealizingPort()) == null) continue;
                result.add((ModelElement)port);
            }
        }
        return result;
    }

    public static List<ModelElement> getTransitionerElements(ModelElement element_p) {
        return EIAllocationModelHelpers.getTransitionerElements(Collections.singletonList(element_p));
    }

    public static List<ModelElement> getTransitionerElements(List<ModelElement> elements_p) {
        ArrayList<ModelElement> result = new ArrayList<ModelElement>();
        for (ModelElement elt : elements_p) {
            if (elt instanceof AbstractFunction) {
                for (AbstractTrace trace : ((AbstractFunction)elt).getOutgoingTraces()) {
                    AbstractFunction fct;
                    if (!(trace instanceof FunctionRealization) || (fct = ((FunctionRealization)trace).getAllocatedFunction()) == null) continue;
                    result.add((ModelElement)fct);
                }
                continue;
            }
            if (!(elt instanceof FunctionPort)) continue;
            for (AbstractTrace trace : ((FunctionPort)elt).getOutgoingTraces()) {
                Port port;
                if (!(trace instanceof PortRealization) || (port = ((PortRealization)trace).getRealizedPort()) == null) continue;
                result.add((ModelElement)port);
            }
        }
        return result;
    }

    public static List<EObject> getOwners(ExchangeItem exchangeItem_p) {
        return EObjectExt.getReferencers((EObject)exchangeItem_p, Arrays.asList(FaPackage.Literals.FUNCTION_INPUT_PORT__INCOMING_EXCHANGE_ITEMS, FaPackage.Literals.FUNCTION_OUTPUT_PORT__OUTGOING_EXCHANGE_ITEMS));
    }

    public static void handleDeletion(Collection<?> selection_p) {
        Collection<EObject> elts = EIAllocationModelHelpers.filterFunctionsAndPorts(selection_p);
        CapellaDeleteCommand cmd = new CapellaDeleteCommand(TransactionHelper.getExecutionManager(elts), elts, false, false, false);
        if (cmd.canExecute()) {
            cmd.execute();
        }
    }

    public static Collection<EObject> filterFunctionsAndPorts(Collection<?> selection_p) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (Object obj : selection_p) {
            if (!(obj instanceof AbstractFunction) && !(obj instanceof FunctionPort)) continue;
            result.add((EObject)obj);
        }
        return result;
    }

    public static void handleAllocation(FunctionPort sepFunctionPort_p, FunctionPort tepFunctionPort_p, ExchangeItem exchangeItem_p) {
        if (tepFunctionPort_p != null && exchangeItem_p != null) {
            EList outgoingEI;
            if (tepFunctionPort_p instanceof FunctionInputPort) {
                EList incomingEI = ((FunctionInputPort)tepFunctionPort_p).getIncomingExchangeItems();
                if (!incomingEI.contains(exchangeItem_p)) {
                    incomingEI.add(exchangeItem_p);
                }
            } else if (tepFunctionPort_p instanceof FunctionOutputPort && !(outgoingEI = ((FunctionOutputPort)tepFunctionPort_p).getOutgoingExchangeItems()).contains(exchangeItem_p)) {
                outgoingEI.add(exchangeItem_p);
            }
            EIAllocationModelHelpers.handleAllocation(tepFunctionPort_p, sepFunctionPort_p);
        }
    }

    public static void handleAllocation(AbstractFunction source_p, AbstractFunction target_p) {
        boolean alreadyRealized = false;
        for (FunctionRealization rlz : source_p.getOutFunctionRealizations()) {
            AbstractFunction fct = rlz.getAllocatedFunction();
            if (!target_p.equals(fct)) continue;
            alreadyRealized = true;
            break;
        }
        if (!alreadyRealized) {
            FunctionRealization rlz;
            rlz = FaFactory.eINSTANCE.createFunctionRealization();
            rlz.setSourceElement((TraceableElement)source_p);
            rlz.setTargetElement((TraceableElement)target_p);
            source_p.getOwnedFunctionRealizations().add((Object)rlz);
        }
    }

    public static void handleAllocation(FunctionPort source_p, FunctionPort target_p) {
        boolean alreadyRealized = false;
        if (source_p instanceof FunctionInputPort && target_p instanceof FunctionInputPort || source_p instanceof FunctionOutputPort && target_p instanceof FunctionOutputPort) {
            for (PortRealization rlz : source_p.getOutgoingPortRealizations()) {
                Port port = rlz.getRealizedPort();
                if (!target_p.equals(port)) continue;
                alreadyRealized = true;
                break;
            }
            if (!alreadyRealized) {
                PortRealization rlz;
                rlz = InformationFactory.eINSTANCE.createPortRealization();
                rlz.setSourceElement((TraceableElement)source_p);
                rlz.setTargetElement((TraceableElement)target_p);
                source_p.getOwnedPortRealizations().add((Object)rlz);
            }
        }
    }

    public static boolean isSameType(List<EObject> elements_p) {
        if (elements_p != null && !elements_p.isEmpty()) {
            EClass cls = elements_p.get(0).eClass();
            for (EObject elt : elements_p) {
                if (elt.eClass().equals(cls)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isSupportedType(Object element_p) {
        return !(element_p instanceof ExchangeItem);
    }

    public static boolean isCompatibleType(Object element1_p, Object element2_p) {
        if (element1_p instanceof AbstractFunction && element2_p instanceof AbstractFunction) {
            return true;
        }
        if (element1_p instanceof FunctionPort && element2_p instanceof FunctionPort) {
            return EIAllocationModelHelpers.isSamePortType((FunctionPort)element1_p, (FunctionPort)element2_p);
        }
        return false;
    }

    private static boolean isSamePortType(FunctionPort element1_p, FunctionPort element2_p) {
        return element1_p instanceof FunctionInputPort && element2_p instanceof FunctionInputPort || element1_p instanceof FunctionOutputPort && element2_p instanceof FunctionOutputPort;
    }

    public static boolean isValidTypeForDeletion(List<EObject> elements_p) {
        if (elements_p != null && !elements_p.isEmpty()) {
            for (EObject elt : elements_p) {
                if (elt instanceof AbstractFunction || elt instanceof FunctionPort) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isDelegated(ExchangeItem exchangeItem_p, FunctionPort port_p) {
        boolean isDelegated = false;
        for (PortRealization rlz : port_p.getIncomingPortRealizations()) {
            Port srcPort = rlz.getRealizingPort();
            if (srcPort instanceof FunctionInputPort && ((FunctionInputPort)srcPort).getIncomingExchangeItems().contains((Object)exchangeItem_p)) {
                isDelegated = true;
                continue;
            }
            if (!(srcPort instanceof FunctionOutputPort) || !((FunctionOutputPort)srcPort).getOutgoingExchangeItems().contains((Object)exchangeItem_p)) continue;
            isDelegated = true;
        }
        return isDelegated;
    }

    public static boolean isDelegator(ExchangeItem exchangeItem_p, FunctionPort port_p) {
        boolean isDelegated = false;
        for (PortRealization rlz : port_p.getOutgoingPortRealizations()) {
            Port dstPort = rlz.getRealizedPort();
            if (dstPort instanceof FunctionInputPort && ((FunctionInputPort)dstPort).getIncomingExchangeItems().contains((Object)exchangeItem_p)) {
                isDelegated = true;
                continue;
            }
            if (!(dstPort instanceof FunctionOutputPort) || !((FunctionOutputPort)dstPort).getOutgoingExchangeItems().contains((Object)exchangeItem_p)) continue;
            isDelegated = true;
        }
        return isDelegated;
    }
}

