/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.helpers.interaction.services.MessageEndExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.refinement.scenarios.core.RefinementServices;
import org.polarsys.capella.core.refinement.scenarios.core.datastructures.ScenarioRepresentation;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ResolverException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IResolver;

public class StandardResolving
implements IResolver {
    public Object getName() {
        return "Standard Resolver";
    }

    public List<AbstractInstance> resolving(List<AbstractInstance> candidateAbstractInstances, ScenarioRepresentation srcTree, ScenarioRepresentation tgtTree, AbstractEnd srcMsg, MessageEndExt.COMPONENT_TYPE type) throws ResolverException {
        ArrayList<AbstractInstance> selectedAbstractInstances = new ArrayList<AbstractInstance>();
        if (candidateAbstractInstances != null && srcMsg != null) {
            MessageEnd tgtMsg = null;
            for (CapellaElement msg : RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)srcMsg, (EClass)InteractionPackage.Literals.MESSAGE_END)) {
                if (!CapellaElementExt.areInSameDecompositionAlternative((CapellaElement)msg, (CapellaElement)tgtTree.getScenario())) continue;
                tgtMsg = (MessageEnd)msg;
            }
            if (tgtMsg != null) {
                AbstractInstance inst = tgtMsg.getCovered().getRepresentedInstance();
                if (inst instanceof Part) {
                    Part currentTargetPart = (Part)inst;
                    Component currentTargetComponent = (Component)currentTargetPart.getAbstractType();
                    AbstractEventOperation op = MessageEndExt.getOperation((MessageEnd)tgtMsg);
                    ArrayList<Part> validParts = new ArrayList<Part>();
                    if (type == MessageEndExt.COMPONENT_TYPE.SENDER) {
                        if (op instanceof AbstractExchangeItem) {
                            for (Interface itf : ComponentExt.getAllUsedAndRequiredInterfaces((Component)currentTargetComponent)) {
                                if (!itf.getExchangeItems().contains((Object)op)) continue;
                                for (Component cpnt : this.getAllUsers(itf)) {
                                    for (Part part : RefinementServices.getReferencerParts((Component)cpnt)) {
                                        if (!candidateAbstractInstances.contains(part)) continue;
                                        validParts.add(part);
                                    }
                                }
                            }
                        }
                    } else if (type == MessageEndExt.COMPONENT_TYPE.RECEIVER) {
                        for (Interface itf : ComponentExt.getAllImplementedAndProvidedInterfaces((Component)currentTargetComponent)) {
                            if (!itf.getExchangeItems().contains((Object)op)) continue;
                            for (Component cpnt : this.getAllImplementors(itf)) {
                                for (Part part : RefinementServices.getReferencerParts((Component)cpnt)) {
                                    if (!candidateAbstractInstances.contains(part)) continue;
                                    validParts.add(part);
                                }
                            }
                        }
                    }
                    if (validParts.contains(currentTargetPart)) {
                        selectedAbstractInstances.add((AbstractInstance)currentTargetPart);
                    } else {
                        selectedAbstractInstances.addAll(validParts);
                    }
                } else {
                    selectedAbstractInstances.addAll(candidateAbstractInstances);
                }
            } else {
                selectedAbstractInstances.addAll(candidateAbstractInstances);
            }
        } else {
            selectedAbstractInstances.addAll(candidateAbstractInstances);
        }
        return selectedAbstractInstances;
    }

    private Collection<Component> getAllUsers(Interface itf) {
        HashSet<Component> users = new HashSet<Component>();
        for (Component cpnt : itf.getUserComponents()) {
            users.add(cpnt);
            for (GeneralizableElement elt : GeneralizableElementExt.getAllSubGeneralizableElements((GeneralizableElement)cpnt)) {
                if (!(elt instanceof Component) || users.contains(elt)) continue;
                users.add(cpnt);
            }
        }
        for (EObject obj : EObjectExt.getReferencers((EObject)itf, (EReference)InformationPackage.Literals.PORT__REQUIRED_INTERFACES)) {
            EObject owner;
            if (!(obj instanceof Port) || !((owner = ((Port)obj).eContainer()) instanceof Component) || users.contains(owner)) continue;
            users.add((Component)owner);
        }
        return users;
    }

    private Collection<Component> getAllImplementors(Interface itf) {
        HashSet<Component> implementors = new HashSet<Component>();
        for (Component cpnt : itf.getImplementorComponents()) {
            implementors.add(cpnt);
            for (GeneralizableElement elt : GeneralizableElementExt.getAllSubGeneralizableElements((GeneralizableElement)cpnt)) {
                if (!(elt instanceof Component) || implementors.contains(elt)) continue;
                implementors.add(cpnt);
            }
        }
        for (EObject obj : EObjectExt.getReferencers((EObject)itf, (EReference)InformationPackage.Literals.PORT__PROVIDED_INTERFACES)) {
            EObject owner;
            if (!(obj instanceof Port) || !((owner = ((Port)obj).eContainer()) instanceof Component) || implementors.contains(owner)) continue;
            implementors.add((Component)owner);
        }
        return implementors;
    }
}

