/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cs.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.GeneralClass;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceAllocation;
import org.polarsys.capella.core.data.cs.InterfaceAllocator;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.GeneralClassHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.InterfaceAllocatorHelper;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.la.ContextInterfaceRealization;
import org.polarsys.capella.core.data.pa.LogicalInterfaceRealization;

public class InterfaceHelper {
    private static InterfaceHelper instance;

    private InterfaceHelper() {
    }

    public static InterfaceHelper getInstance() {
        if (instance == null) {
            instance = new InterfaceHelper();
        }
        return instance;
    }

    public Object doSwitch(Interface element, EStructuralFeature feature) {
        List<Component> ret = null;
        if (feature.equals(CsPackage.Literals.INTERFACE__ALLOCATING_INTERFACES)) {
            ret = this.getAllocatingInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__ALLOCATING_COMPONENTS)) {
            ret = this.getAllocatingComponents(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__IMPLEMENTOR_COMPONENTS)) {
            ret = this.getImplementorComponents(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__USER_COMPONENTS)) {
            ret = this.getUserComponents(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__PROVISIONING_INTERFACE_ALLOCATIONS)) {
            ret = this.getProvisioningInterfaceAllocations(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__INTERFACE_IMPLEMENTATIONS)) {
            ret = this.getInterfaceImplementations(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__INTERFACE_USES)) {
            ret = this.getInterfaceUses(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__EXCHANGE_ITEMS)) {
            ret = this.getExchangeItems(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__REQUIRING_COMPONENTS)) {
            ret = this.getRequiringComponents(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__PROVIDING_COMPONENTS)) {
            ret = this.getProvidingComponents(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__REQUIRING_COMPONENT_PORTS)) {
            ret = this.getRequiringComponentPorts(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__PROVIDING_COMPONENT_PORTS)) {
            ret = this.getProvidingComponentPorts(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__REALIZING_LOGICAL_INTERFACES)) {
            ret = this.getRealizingLogicalInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__REALIZED_CONTEXT_INTERFACES)) {
            ret = this.getRealizedContextInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__REALIZING_PHYSICAL_INTERFACES)) {
            ret = this.getRealizingPhysicalInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE__REALIZED_LOGICAL_INTERFACES)) {
            ret = this.getRealizedLogicalInterfaces(element);
        }
        if (ret == null) {
            ret = InterfaceAllocatorHelper.getInstance().doSwitch((InterfaceAllocator)element, feature);
        }
        if (ret == null) {
            ret = GeneralClassHelper.getInstance().doSwitch((GeneralClass)element, feature);
        }
        return ret;
    }

    protected List<ExchangeItem> getExchangeItems(Interface element) {
        ArrayList<ExchangeItem> ret = new ArrayList<ExchangeItem>();
        for (ExchangeItemAllocation exchangeItemAllocation : element.getOwnedExchangeItemAllocations()) {
            ExchangeItem item = exchangeItemAllocation.getAllocatedItem();
            if (item == null) continue;
            ret.add(item);
        }
        return ret;
    }

    protected List<InterfaceImplementation> getInterfaceImplementations(Interface element) {
        return EObjectExt.getReferencers((EObject)element, (EReference)CsPackage.Literals.INTERFACE_IMPLEMENTATION__IMPLEMENTED_INTERFACE);
    }

    protected List<InterfaceUse> getInterfaceUses(Interface element) {
        return EObjectExt.getReferencers((EObject)element, (EReference)CsPackage.Literals.INTERFACE_USE__USED_INTERFACE);
    }

    protected List<Component> getImplementorComponents(Interface element) {
        ArrayList<Component> ret = new ArrayList<Component>();
        for (InterfaceImplementation interfaceImplementation : element.getInterfaceImplementations()) {
            Component interfaceImplementor = interfaceImplementation.getInterfaceImplementor();
            if (interfaceImplementor == null) continue;
            ret.add(interfaceImplementor);
        }
        return ret;
    }

    protected List<Component> getUserComponents(Interface element) {
        ArrayList<Component> ret = new ArrayList<Component>();
        for (InterfaceUse interfaceUse : element.getInterfaceUses()) {
            Component interfaceUser = interfaceUse.getInterfaceUser();
            if (interfaceUser == null) continue;
            ret.add(interfaceUser);
        }
        return ret;
    }

    protected List<Interface> getAllocatingInterfaces(Interface element) {
        ArrayList<Interface> ret = new ArrayList<Interface>();
        for (InterfaceAllocation interfaceAllocation : element.getProvisionedInterfaceAllocations()) {
            InterfaceAllocator allocator = interfaceAllocation.getAllocatingInterfaceAllocator();
            if (!(allocator instanceof Interface)) continue;
            ret.add((Interface)allocator);
        }
        return ret;
    }

    protected List<Component> getAllocatingComponents(Interface element) {
        ArrayList<Component> ret = new ArrayList<Component>();
        for (InterfaceAllocation interfaceAllocation : element.getProvisionedInterfaceAllocations()) {
            InterfaceAllocator allocator = interfaceAllocation.getAllocatingInterfaceAllocator();
            if (!(allocator instanceof Component)) continue;
            ret.add((Component)allocator);
        }
        return ret;
    }

    protected List<InterfaceAllocation> getProvisioningInterfaceAllocations(Interface element) {
        ArrayList<InterfaceAllocation> ret = new ArrayList<InterfaceAllocation>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            if (!(trace instanceof InterfaceAllocation)) continue;
            ret.add((InterfaceAllocation)trace);
        }
        return ret;
    }

    protected List<Component> getRequiringComponents(Interface element) {
        ArrayList<Component> ret = new ArrayList<Component>();
        for (ComponentPort port : element.getRequiringComponentPorts()) {
            EObject obj = port.eContainer();
            if (!(obj instanceof Component)) continue;
            ret.add((Component)obj);
        }
        return ret;
    }

    protected List<Component> getProvidingComponents(Interface element) {
        ArrayList<Component> ret = new ArrayList<Component>();
        for (ComponentPort port : element.getProvidingComponentPorts()) {
            EObject obj = port.eContainer();
            if (!(obj instanceof Component)) continue;
            ret.add((Component)obj);
        }
        return ret;
    }

    protected List<ComponentPort> getRequiringComponentPorts(Interface element) {
        ArrayList<ComponentPort> ret = new ArrayList<ComponentPort>();
        for (EObject obj : EObjectExt.getReferencers((EObject)element, (EReference)InformationPackage.Literals.PORT__REQUIRED_INTERFACES)) {
            if (!(obj instanceof ComponentPort)) continue;
            ret.add((ComponentPort)obj);
        }
        return ret;
    }

    protected List<ComponentPort> getProvidingComponentPorts(Interface element) {
        ArrayList<ComponentPort> ret = new ArrayList<ComponentPort>();
        for (EObject obj : EObjectExt.getReferencers((EObject)element, (EReference)InformationPackage.Literals.PORT__PROVIDED_INTERFACES)) {
            if (!(obj instanceof ComponentPort)) continue;
            ret.add((ComponentPort)obj);
        }
        return ret;
    }

    protected List<Interface> getRealizingLogicalInterfaces(Interface element) {
        ArrayList<Interface> result = new ArrayList<Interface>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement src;
            if (!(trace instanceof ContextInterfaceRealization) || !((src = ((ContextInterfaceRealization)trace).getSourceElement()) instanceof Interface)) continue;
            result.add((Interface)src);
        }
        return result;
    }

    protected List<Interface> getRealizedContextInterfaces(Interface element) {
        ArrayList<Interface> result = new ArrayList<Interface>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            TraceableElement src;
            if (!(trace instanceof ContextInterfaceRealization) || !((src = ((ContextInterfaceRealization)trace).getTargetElement()) instanceof Interface)) continue;
            result.add((Interface)src);
        }
        return result;
    }

    protected List<Interface> getRealizingPhysicalInterfaces(Interface element) {
        ArrayList<Interface> result = new ArrayList<Interface>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement src;
            if (!(trace instanceof LogicalInterfaceRealization) || !((src = ((LogicalInterfaceRealization)trace).getSourceElement()) instanceof Interface)) continue;
            result.add((Interface)src);
        }
        return result;
    }

    protected List<Interface> getRealizedLogicalInterfaces(Interface element) {
        ArrayList<Interface> result = new ArrayList<Interface>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            TraceableElement src;
            if (!(trace instanceof LogicalInterfaceRealization) || !((src = ((LogicalInterfaceRealization)trace).getTargetElement()) instanceof Interface)) continue;
            result.add((Interface)src);
        }
        return result;
    }
}

