/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.ctx.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentAllocation;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.OperationalEntityRealization;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemCapabilityInvolvement;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.ctx.SystemMissionInvolvement;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.capellacommon.delegates.CapabilityRealizationInvolvedElementHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.ComponentHelper;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.Entity;

public class SystemHelper {
    private static SystemHelper instance;

    private SystemHelper() {
    }

    public static SystemHelper getInstance() {
        if (instance == null) {
            instance = new SystemHelper();
        }
        return instance;
    }

    public Object doSwitch(System element, EStructuralFeature feature) {
        List<Mission> ret = null;
        if (feature.equals(CtxPackage.Literals.SYSTEM__PARTICIPATIONS_IN_CAPABILITIES)) {
            ret = this.getParticipationsInCapabilities(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM__PARTICIPATIONS_IN_MISSIONS)) {
            ret = this.getParticipationsInMissions(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM__CONTRIBUTED_CAPABILITIES)) {
            ret = this.getContributedCapabilities(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM__CONTRIBUTED_MISSIONS)) {
            ret = this.getContributedMissions(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM__ALLOCATED_ENTITY_REALIZATIONS)) {
            ret = this.getAllocatedEntityRealizations(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM__ALLOCATED_SYSTEM_FUNCTIONS)) {
            ret = this.getAllocatedSystemFunctions(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM__REALIZED_ENTITIES)) {
            ret = this.getRealizedEntities(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM__REALIZING_LOGICAL_COMPONENTS)) {
            ret = this.getRealizingLogicalComponents(element);
        }
        if (ret == null) {
            ret = CapabilityRealizationInvolvedElementHelper.getInstance().doSwitch((CapabilityRealizationInvolvedElement)element, feature);
        }
        if (ret == null) {
            ret = ComponentHelper.getInstance().doSwitch((Component)element, feature);
        }
        return ret;
    }

    protected List<SystemCapabilityInvolvement> getParticipationsInCapabilities(System element) {
        ArrayList<SystemCapabilityInvolvement> ret = new ArrayList<SystemCapabilityInvolvement>();
        for (Involvement involvement : element.getInvolvingInvolvements()) {
            if (!(involvement instanceof SystemCapabilityInvolvement)) continue;
            ret.add((SystemCapabilityInvolvement)involvement);
        }
        return ret;
    }

    protected List<SystemMissionInvolvement> getParticipationsInMissions(System element) {
        ArrayList<SystemMissionInvolvement> ret = new ArrayList<SystemMissionInvolvement>();
        for (Involvement involvement : element.getInvolvingInvolvements()) {
            if (!(involvement instanceof SystemMissionInvolvement)) continue;
            ret.add((SystemMissionInvolvement)involvement);
        }
        return ret;
    }

    protected List<Capability> getContributedCapabilities(System element) {
        ArrayList<Capability> ret = new ArrayList<Capability>();
        for (SystemCapabilityInvolvement capabilitySupplierLink : element.getParticipationsInCapabilities()) {
            Capability capa = capabilitySupplierLink.getCapability();
            if (capa == null) continue;
            ret.add(capa);
        }
        return ret;
    }

    protected List<Mission> getContributedMissions(System element) {
        ArrayList<Mission> ret = new ArrayList<Mission>();
        for (SystemMissionInvolvement missionSupplierLink : element.getParticipationsInMissions()) {
            Mission mission = missionSupplierLink.getMission();
            if (mission == null) continue;
            ret.add(mission);
        }
        return ret;
    }

    protected List<OperationalEntityRealization> getAllocatedEntityRealizations(System element) {
        ArrayList<OperationalEntityRealization> ret = new ArrayList<OperationalEntityRealization>();
        for (ComponentAllocation componentAllocation : element.getProvisionedComponentAllocations()) {
            if (!(componentAllocation instanceof OperationalEntityRealization)) continue;
            ret.add((OperationalEntityRealization)componentAllocation);
        }
        return ret;
    }

    protected List<SystemFunction> getAllocatedSystemFunctions(System element) {
        ArrayList<SystemFunction> ret = new ArrayList<SystemFunction>();
        for (AbstractFunction function : element.getAllocatedFunctions()) {
            if (!(function instanceof SystemFunction)) continue;
            ret.add((SystemFunction)function);
        }
        return ret;
    }

    protected List<Entity> getRealizedEntities(System element) {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            Component cpnt;
            if (!(trace instanceof OperationalEntityRealization) || !((cpnt = ((OperationalEntityRealization)trace).getAllocatedComponent()) instanceof Entity)) continue;
            ret.add((Entity)cpnt);
        }
        return ret;
    }

    protected List<LogicalComponent> getRealizingLogicalComponents(System element) {
        ArrayList<LogicalComponent> ret = new ArrayList<LogicalComponent>();
        for (Component cpnt : element.getAllocatingComponents()) {
            if (!(cpnt instanceof LogicalComponent)) continue;
            ret.add((LogicalComponent)cpnt);
        }
        return ret;
    }
}

