/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.fa.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.helpers.modellingcore.delegates.AbstractTypeHelper;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellacore.Relationship;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchangeRealization;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.InvolvedElementHelper;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.NamedElementHelper;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.RelationshipHelper;
import org.polarsys.capella.core.data.helpers.information.delegates.AbstractEventOperationHelper;
import org.polarsys.capella.core.data.information.AbstractEventOperation;

public class FunctionalExchangeHelper {
    private static FunctionalExchangeHelper instance;

    private FunctionalExchangeHelper() {
    }

    public static FunctionalExchangeHelper getInstance() {
        if (instance == null) {
            instance = new FunctionalExchangeHelper();
        }
        return instance;
    }

    public Object doSwitch(FunctionalExchange element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(FaPackage.Literals.FUNCTIONAL_EXCHANGE__INVOLVING_FUNCTIONAL_CHAINS)) {
            ret = this.getInvolvingFunctionalChains(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_EXCHANGE__ALLOCATING_COMPONENT_EXCHANGES)) {
            ret = this.getComponentExchanges(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_EXCHANGE__INCOMING_COMPONENT_EXCHANGE_FUNCTIONAL_EXCHANGE_REALIZATIONS)) {
            ret = this.getIncomingComponentExchangeFunctionalExchangeAllocations(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_EXCHANGE__INCOMING_FUNCTIONAL_EXCHANGE_REALIZATIONS)) {
            ret = this.getIncomingFunctionalExchangeRealizations(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_EXCHANGE__OUTGOING_FUNCTIONAL_EXCHANGE_REALIZATIONS)) {
            ret = this.getOutgoingFunctionalExchangeRealizations(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_EXCHANGE__SOURCE_FUNCTION_OUTPUT_PORT)) {
            ret = this.getSourceFunctionOutputPort(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_EXCHANGE__TARGET_FUNCTION_INPUT_PORT)) {
            ret = this.getTargetFunctionInputPort(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_EXCHANGE__REALIZED_FUNCTIONAL_EXCHANGES)) {
            ret = this.getRealizedFunctionalExchanges(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_EXCHANGE__REALIZING_FUNCTIONAL_EXCHANGES)) {
            ret = this.getRealizingFunctionalExchanges(element);
        }
        if (ret == null) {
            ret = NamedElementHelper.getInstance().doSwitch((NamedElement)element, feature);
        }
        if (ret == null) {
            ret = AbstractTypeHelper.getInstance().doSwitch((AbstractType)element, feature);
        }
        if (ret == null) {
            ret = InvolvedElementHelper.getInstance().doSwitch((InvolvedElement)element, feature);
        }
        if (ret == null) {
            ret = RelationshipHelper.getInstance().doSwitch((Relationship)element, feature);
        }
        if (ret == null) {
            ret = AbstractEventOperationHelper.getInstance().doSwitch((AbstractEventOperation)element, feature);
        }
        return ret;
    }

    protected List<FunctionalChain> getInvolvingFunctionalChains(FunctionalExchange element) {
        ArrayList<FunctionalChain> ret = new ArrayList<FunctionalChain>();
        for (Involvement involvement : element.getInvolvingInvolvements()) {
            InvolverElement fc;
            if (!(involvement instanceof FunctionalChainInvolvement) || (fc = involvement.getInvolver()) == null || !(fc instanceof FunctionalChain)) continue;
            ret.add((FunctionalChain)fc);
        }
        return ret;
    }

    protected List<ComponentExchange> getComponentExchanges(FunctionalExchange element) {
        ArrayList<ComponentExchange> ret = new ArrayList<ComponentExchange>();
        for (ComponentExchangeFunctionalExchangeAllocation item : element.getIncomingComponentExchangeFunctionalExchangeRealizations()) {
            if (item.getAllocatingComponentExchange() == null) continue;
            ret.add(item.getAllocatingComponentExchange());
        }
        return ret;
    }

    protected List<ComponentExchangeFunctionalExchangeAllocation> getIncomingComponentExchangeFunctionalExchangeAllocations(FunctionalExchange element) {
        ArrayList<ComponentExchangeFunctionalExchangeAllocation> ret = new ArrayList<ComponentExchangeFunctionalExchangeAllocation>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            if (!(trace instanceof ComponentExchangeFunctionalExchangeAllocation)) continue;
            ret.add((ComponentExchangeFunctionalExchangeAllocation)trace);
        }
        return ret;
    }

    protected List<FunctionalExchangeRealization> getIncomingFunctionalExchangeRealizations(FunctionalExchange element) {
        ArrayList<FunctionalExchangeRealization> ret = new ArrayList<FunctionalExchangeRealization>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            if (!(trace instanceof FunctionalExchangeRealization)) continue;
            ret.add((FunctionalExchangeRealization)trace);
        }
        return ret;
    }

    protected List<FunctionalExchangeRealization> getOutgoingFunctionalExchangeRealizations(FunctionalExchange element) {
        ArrayList<FunctionalExchangeRealization> ret = new ArrayList<FunctionalExchangeRealization>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            if (!(trace instanceof FunctionalExchangeRealization)) continue;
            ret.add((FunctionalExchangeRealization)trace);
        }
        return ret;
    }

    protected FunctionOutputPort getSourceFunctionOutputPort(FunctionalExchange element) {
        ActivityNode activityNode = element.getSource();
        if (activityNode instanceof FunctionOutputPort) {
            return (FunctionOutputPort)activityNode;
        }
        return null;
    }

    protected FunctionInputPort getTargetFunctionInputPort(FunctionalExchange element) {
        ActivityNode activityNode = element.getTarget();
        if (activityNode instanceof FunctionInputPort) {
            return (FunctionInputPort)activityNode;
        }
        return null;
    }

    protected List<FunctionalExchange> getRealizedFunctionalExchanges(FunctionalExchange element) {
        ArrayList<FunctionalExchange> ret = new ArrayList<FunctionalExchange>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            TraceableElement tgt;
            if (!(trace instanceof FunctionalExchangeRealization) || !((tgt = trace.getTargetElement()) instanceof FunctionalExchange)) continue;
            ret.add((FunctionalExchange)tgt);
        }
        return ret;
    }

    protected List<FunctionalExchange> getRealizingFunctionalExchanges(FunctionalExchange element) {
        ArrayList<FunctionalExchange> ret = new ArrayList<FunctionalExchange>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement src;
            if (!(trace instanceof FunctionalExchangeRealization) || !((src = trace.getSourceElement()) instanceof FunctionalExchange)) continue;
            ret.add((FunctionalExchange)src);
        }
        return ret;
    }
}

