/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.fa.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.activity.InputPin;
import org.polarsys.capella.common.data.activity.OutputPin;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionKind;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionPkgExt;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.pa.PhysicalFunction;

public class FunctionExt {
    public static List<AbstractFunction> getRealizedFunctions(AbstractFunction fct) {
        ArrayList<AbstractFunction> result = new ArrayList<AbstractFunction>();
        for (AbstractTrace trace : fct.getOutgoingTraces()) {
            if (!(trace instanceof FunctionRealization)) continue;
            result.add(((FunctionRealization)trace).getAllocatedFunction());
        }
        return result;
    }

    public static List<AbstractFunction> getRealizingFunctions(AbstractFunction fct) {
        ArrayList<AbstractFunction> result = new ArrayList<AbstractFunction>();
        for (AbstractTrace trace : fct.getIncomingTraces()) {
            if (!(trace instanceof FunctionRealization)) continue;
            result.add(((FunctionRealization)trace).getAllocatingFunction());
        }
        return result;
    }

    public static final boolean isLeaf(AbstractFunction function) {
        if (function == null) {
            return false;
        }
        return function.getSubFunctions().size() == 0;
    }

    public static boolean isControlNodeOneOutput(AbstractFunction function) {
        return function.getKind() == FunctionKind.GATHER || function.getKind() == FunctionKind.ROUTE;
    }

    public static boolean isControlNodeOneInput(AbstractFunction function) {
        return function.getKind() == FunctionKind.DUPLICATE || function.getKind() == FunctionKind.SPLIT || function.getKind() == FunctionKind.SELECT;
    }

    public static boolean isDuplicateFunction(AbstractFunction function) {
        return function.getKind() == FunctionKind.DUPLICATE;
    }

    public static boolean isGatherFunction(AbstractFunction function) {
        return function.getKind() == FunctionKind.GATHER;
    }

    public static boolean isRouteFunction(AbstractFunction function) {
        return function.getKind() == FunctionKind.ROUTE;
    }

    public static boolean isSelectFunction(AbstractFunction function) {
        return function.getKind() == FunctionKind.SELECT;
    }

    public static boolean isSplitFunction(AbstractFunction function) {
        return function.getKind() == FunctionKind.SPLIT;
    }

    public static List<CapellaElement> getAllocatedFunctionalExchangeFiltered(AbstractFunctionalBlock sourceEntity, AbstractFunctionalBlock targetEntity) {
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>(1);
        if (sourceEntity != null && targetEntity != null) {
            EList srcAllocatedFuns = sourceEntity.getAllocatedFunctions();
            EList tarAllocatedFuns = targetEntity.getAllocatedFunctions();
            for (AbstractFunction abstractFunction : srcAllocatedFuns) {
                EList outgoing = abstractFunction.getOutgoing();
                for (ActivityEdge activityEdge : outgoing) {
                    ActivityNode target = activityEdge.getTarget();
                    if (target == null || !tarAllocatedFuns.contains((Object)target)) continue;
                    list.add((CapellaElement)activityEdge);
                }
            }
        }
        return list;
    }

    public static List<CapellaElement> getAllocatedFunctionalExchangeFilteredWithPort(AbstractFunctionalBlock sourceEntity, AbstractFunctionalBlock targetEntity) {
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>(1);
        if (sourceEntity != null && targetEntity != null) {
            EList srcAllocatedFuns = sourceEntity.getAllocatedFunctions();
            EList tarAllocatedFuns = targetEntity.getAllocatedFunctions();
            for (AbstractFunction abstractFunction : srcAllocatedFuns) {
                List<FunctionalExchange> outGoingExchange = FunctionExt.getOutGoingExchange(abstractFunction);
                for (FunctionalExchange functionalExchange : outGoingExchange) {
                    AbstractFunction outGoingAbstractFunction = FunctionExt.getOutGoingAbstractFunction(functionalExchange);
                    if (outGoingAbstractFunction == null || !tarAllocatedFuns.contains((Object)outGoingAbstractFunction)) continue;
                    list.add((CapellaElement)functionalExchange);
                }
            }
        }
        return list;
    }

    public static List<FunctionalExchange> getOutGoingExchange(AbstractFunction function) {
        BasicEList result = new BasicEList();
        EList outgoing = function.getOutgoing();
        for (ActivityEdge activityEdge : outgoing) {
            result.add((FunctionalExchange)activityEdge);
        }
        return result;
    }

    public static List<FunctionalExchange> getAllOutgoingExchanges(AbstractFunction function) {
        if (function.getOwnedFunctions().isEmpty()) {
            return FunctionExt.getOutGoingExchange(function);
        }
        List<FunctionalExchange> result = FunctionExt.getOutGoingExchange(function);
        for (AbstractFunction abstractFunction : function.getOwnedFunctions()) {
            List<FunctionalExchange> outgoings = FunctionExt.getAllOutgoingExchanges(abstractFunction);
            for (FunctionalExchange activityEdge : outgoings) {
                if (EcoreUtil2.isContainedBy((EObject)activityEdge.getTarget(), (EObject)function)) continue;
                result.add(activityEdge);
            }
        }
        return result;
    }

    public static List<FunctionalExchange> getAllIncomingExchanges(AbstractFunction function) {
        if (function.getOwnedFunctions().isEmpty()) {
            return FunctionExt.getIncomingExchange(function);
        }
        List<FunctionalExchange> result = FunctionExt.getIncomingExchange(function);
        for (AbstractFunction abstractFunction : function.getOwnedFunctions()) {
            List<FunctionalExchange> incomings = FunctionExt.getAllIncomingExchanges(abstractFunction);
            for (FunctionalExchange activityEdge : incomings) {
                if (EcoreUtil2.isContainedBy((EObject)activityEdge.getSource(), (EObject)function)) continue;
                result.add(activityEdge);
            }
        }
        return result;
    }

    public static List<FunctionalExchange> getAllExchanges(AbstractFunction function) {
        BasicEList result = new BasicEList();
        result.addAll(FunctionExt.getAllIncomingExchanges(function));
        result.addAll(FunctionExt.getAllOutgoingExchanges(function));
        return result;
    }

    public static List<FunctionalExchange> getIncomingExchange(AbstractFunction function) {
        BasicEList result = new BasicEList();
        EList ingoing = function.getIncoming();
        for (ActivityEdge activityEdge : ingoing) {
            result.add((FunctionalExchange)activityEdge);
        }
        return result;
    }

    public static List<FunctionalExchange> getExchanges(AbstractFunction function) {
        BasicEList result = new BasicEList();
        EList ingoing = function.getIncoming();
        for (ActivityEdge activityEdge : ingoing) {
            result.add((FunctionalExchange)activityEdge);
        }
        EList outgoing = function.getOutgoing();
        for (ActivityEdge activityEdge : outgoing) {
            result.add((FunctionalExchange)activityEdge);
        }
        return result;
    }

    public static List<Port> getOwnedFunctionPorts(AbstractFunction function) {
        ArrayList<Port> ports = new ArrayList<Port>();
        for (InputPin inpin : function.getInputs()) {
            if (!(inpin instanceof Port)) continue;
            ports.add((Port)inpin);
        }
        for (OutputPin outpin : function.getOutputs()) {
            if (!(outpin instanceof Port)) continue;
            ports.add((Port)outpin);
        }
        return ports;
    }

    public static AbstractFunction getOutGoingAbstractFunction(FunctionalExchange exchange) {
        EObject container;
        ActivityNode target = exchange.getTarget();
        if (target instanceof FunctionInputPort && (container = ((FunctionInputPort)target).eContainer()) != null) {
            return (AbstractFunction)container;
        }
        if (target instanceof OperationalActivity) {
            return (AbstractFunction)target;
        }
        return null;
    }

    public static AbstractFunction getIncomingAbstractFunction(FunctionalExchange exchange) {
        EObject container;
        ActivityNode source = exchange.getSource();
        if (source instanceof FunctionOutputPort && (container = ((FunctionOutputPort)source).eContainer()) != null) {
            return (AbstractFunction)container;
        }
        if (source instanceof OperationalActivity) {
            return (AbstractFunction)source;
        }
        return null;
    }

    public static Collection<? extends FunctionPkg> getOwnedFunctionPkgs(AbstractFunction function) {
        EList pkgs = Collections.emptyList();
        if (function instanceof OperationalActivity) {
            pkgs = ((OperationalActivity)function).getOwnedOperationalActivityPkgs();
        } else if (function instanceof SystemFunction) {
            pkgs = ((SystemFunction)function).getOwnedSystemFunctionPkgs();
        } else if (function instanceof LogicalFunction) {
            pkgs = ((LogicalFunction)function).getOwnedLogicalFunctionPkgs();
        } else if (function instanceof PhysicalFunction) {
            pkgs = ((PhysicalFunction)function).getOwnedPhysicalFunctionPkgs();
        }
        return pkgs;
    }

    public static Collection<? extends FunctionPkg> getAllFunctionPkgs(AbstractFunction aFunction) {
        ArrayList<Object> returnedList = new ArrayList<Object>();
        if (aFunction == null) {
            return returnedList;
        }
        for (AbstractFunction abstractFunction : aFunction.getOwnedFunctions()) {
            returnedList.addAll(FunctionExt.getAllFunctionPkgs(abstractFunction));
        }
        for (FunctionPkg functionPkg : FunctionExt.getOwnedFunctionPkgs(aFunction)) {
            returnedList.addAll(FunctionPkgExt.getAllFunctionPkgs(functionPkg));
        }
        return returnedList;
    }

    public static List<AbstractFunction> getAllAbstractFunctions(AbstractFunction function) {
        ArrayList<AbstractFunction> returnedList = new ArrayList<AbstractFunction>();
        if (function != null) {
            returnedList.add(function);
            for (AbstractFunction abstractFunction : function.getOwnedFunctions()) {
                returnedList.addAll(FunctionExt.getAllAbstractFunctions(abstractFunction));
            }
            for (FunctionPkg functionPkg : FunctionExt.getOwnedFunctionPkgs(function)) {
                returnedList.addAll(FunctionPkgExt.getAllAbstractFunctions(functionPkg));
            }
        }
        return returnedList;
    }

    public static List<AbstractFunction> getAllLeafAbstractFunctions(AbstractFunction function) {
        ArrayList<AbstractFunction> returnedList = new ArrayList<AbstractFunction>();
        for (AbstractFunction abstractFunction : FunctionExt.getAllAbstractFunctions(function)) {
            if (!FunctionExt.isLeaf(abstractFunction)) continue;
            returnedList.add(abstractFunction);
        }
        return returnedList;
    }

    public static List<AbstractFunction> getAllLeafAbstractFunctions(BlockArchitecture arch) {
        ArrayList<AbstractFunction> returnedList = new ArrayList<AbstractFunction>();
        for (AbstractFunction function : FunctionExt.getAllAbstractFunctions(arch)) {
            if (!FunctionExt.isLeaf(function)) continue;
            returnedList.add(function);
        }
        return returnedList;
    }

    public static List<AbstractFunction> getAllAbstractFunctions(BlockArchitecture blockArchitecture) {
        return FunctionPkgExt.getAllAbstractFunctions(blockArchitecture.getOwnedFunctionPkg());
    }

    public static AbstractFunction getRootFunction(AbstractFunction function) {
        AbstractFunction currentFunction = function;
        EObject currentContainer = function.eContainer();
        while (currentContainer instanceof AbstractFunction) {
            currentFunction = currentContainer;
            currentContainer = currentContainer.eContainer();
        }
        return currentFunction;
    }

    public static Collection<AbstractFunction> getFirstLevelAbstractFunctions(AbstractFunction function) {
        ArrayList<AbstractFunction> result = new ArrayList<AbstractFunction>();
        result.addAll((Collection<AbstractFunction>)function.getOwnedFunctions());
        for (FunctionPkg functionPkg : FunctionExt.getOwnedFunctionPkgs(function)) {
            result.addAll(FunctionPkgExt.getFirstLevelAbstractFunctions(functionPkg));
        }
        return result;
    }

    public static AbstractFunction getParentFunction(AbstractFunction function) {
        EObject parent = EcoreUtil2.getFirstContainer((EObject)function, (EClass)FaPackage.Literals.ABSTRACT_FUNCTION);
        if (parent != null) {
            return (AbstractFunction)parent;
        }
        return null;
    }

    public static AbstractFunction getRelatedFunction(ActivityNode node) {
        if (node instanceof AbstractFunction) {
            return (AbstractFunction)node;
        }
        return (AbstractFunction)EcoreUtil2.getFirstContainer((EObject)node, (EClass)FaPackage.Literals.ABSTRACT_FUNCTION);
    }

    public static List<AbstractFunction> getParentFunctions(AbstractFunction function) {
        ArrayList<AbstractFunction> returnedList = new ArrayList<AbstractFunction>();
        EObject parent = function.eContainer();
        while (parent != null && parent instanceof AbstractFunction) {
            returnedList.add((AbstractFunction)parent);
            parent = parent.eContainer();
        }
        return returnedList;
    }

    public static Collection<FunctionalExchange> getAllOwnedFunctionalExchanges(AbstractFunction function) {
        BasicEList functionExchanges = new BasicEList();
        List<AbstractFunction> subFunctions = FunctionExt.getAllAbstractFunctions(function);
        for (AbstractFunction abstractFunction : subFunctions) {
            functionExchanges.addAll((Collection)abstractFunction.getOwnedFunctionalExchanges());
        }
        return functionExchanges;
    }

    public static boolean isControlNode(AbstractFunction element) {
        return !FunctionKind.FUNCTION.equals((Object)element.getKind());
    }

    public static boolean isFunction(AbstractFunction element) {
        if (element == null) {
            return false;
        }
        EList allocationBlocks = element.getAllocationBlocks();
        for (AbstractFunctionalBlock abstractFunctionalBlock : allocationBlocks) {
            if (!(abstractFunctionalBlock instanceof AbstractActor)) continue;
            return false;
        }
        return FunctionKind.FUNCTION.equals((Object)element.getKind());
    }

    public static boolean isActorFunction(AbstractFunction element) {
        if (element == null) {
            return false;
        }
        EList allocationBlocks = element.getAllocationBlocks();
        for (AbstractFunctionalBlock abstractFunctionalBlock : allocationBlocks) {
            if (!(abstractFunctionalBlock instanceof AbstractActor)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRootFunction(EObject element) {
        AbstractFunction currentFunction;
        AbstractFunction rootFunction;
        return element != null && element instanceof AbstractFunction && (rootFunction = FunctionExt.getRootFunction(currentFunction = (AbstractFunction)element)) != null && rootFunction.equals(currentFunction);
    }
}

