/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.information.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.GeneralizableElementHelper;
import org.polarsys.capella.core.data.information.InformationRealization;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.DatatypePackage;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datatype.NumericType;
import org.polarsys.capella.core.data.information.datatype.PhysicalQuantity;
import org.polarsys.capella.core.data.information.datatype.StringType;
import org.polarsys.capella.core.data.information.datavalue.AbstractBooleanValue;
import org.polarsys.capella.core.data.information.datavalue.AbstractStringValue;
import org.polarsys.capella.core.data.information.datavalue.DataValue;

public class DataTypeHelper {
    private static DataTypeHelper instance;

    private DataTypeHelper() {
    }

    public static DataTypeHelper getInstance() {
        if (instance == null) {
            instance = new DataTypeHelper();
        }
        return instance;
    }

    public Object doSwitch(DataType element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(DatatypePackage.Literals.DATA_TYPE__REALIZED_DATA_TYPES)) {
            ret = this.getRealizedDataTypes(element);
        } else if (feature.equals(DatatypePackage.Literals.DATA_TYPE__REALIZING_DATA_TYPES)) {
            ret = this.getRealizingDataTypes(element);
        } else if (feature.equals(DatatypePackage.Literals.DATA_TYPE__DEFAULT_VALUE)) {
            ret = this.getDefaultValue(element);
        } else if (feature.equals(DatatypePackage.Literals.DATA_TYPE__NULL_VALUE)) {
            ret = this.getNullValue(element);
        }
        if (ret == null) {
            ret = GeneralizableElementHelper.getInstance().doSwitch((GeneralizableElement)element, feature);
        }
        return ret;
    }

    protected List<DataType> getRealizedDataTypes(DataType element) {
        ArrayList<DataType> ret = new ArrayList<DataType>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            TraceableElement elt;
            if (!(trace instanceof InformationRealization) || !((elt = trace.getTargetElement()) instanceof DataType)) continue;
            ret.add((DataType)elt);
        }
        return ret;
    }

    protected List<DataType> getRealizingDataTypes(DataType element) {
        ArrayList<DataType> ret = new ArrayList<DataType>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement elt;
            if (!(trace instanceof InformationRealization) || !((elt = trace.getSourceElement()) instanceof DataType)) continue;
            ret.add((DataType)elt);
        }
        return ret;
    }

    protected DataValue getDefaultValue(DataType element) {
        AbstractBooleanValue ret = null;
        if (element instanceof BooleanType) {
            ret = ((BooleanType)element).getOwnedDefaultValue();
        } else if (element instanceof StringType) {
            ret = ((StringType)element).getOwnedDefaultValue();
        } else if (element instanceof Enumeration) {
            ret = ((Enumeration)element).getOwnedDefaultValue();
        } else if (element instanceof NumericType) {
            ret = ((NumericType)element).getOwnedDefaultValue();
        } else if (element instanceof PhysicalQuantity) {
            ret = ((PhysicalQuantity)element).getOwnedDefaultValue();
        }
        return ret;
    }

    protected DataValue getNullValue(DataType element) {
        AbstractStringValue ret = null;
        if (element instanceof StringType) {
            ret = ((StringType)element).getOwnedNullValue();
        } else if (element instanceof Enumeration) {
            ret = ((Enumeration)element).getOwnedNullValue();
        } else if (element instanceof NumericType) {
            ret = ((NumericType)element).getOwnedNullValue();
        } else if (element instanceof PhysicalQuantity) {
            ret = ((PhysicalQuantity)element).getOwnedNullValue();
        }
        return ret;
    }
}

