/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.information.services;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.InformationRealization;
import org.polarsys.capella.core.data.information.datatype.DataType;

public class DataTypeExt {
    public static List<CapellaElement> getRealizedInformation(DataType dataType) {
        ArrayList<CapellaElement> realizedInformation = new ArrayList<CapellaElement>();
        if (dataType != null) {
            for (InformationRealization realization : dataType.getOwnedInformationRealizations()) {
                TraceableElement elt = realization.getTargetElement();
                if (elt == null) continue;
                realizedInformation.add((CapellaElement)elt);
            }
        }
        return realizedInformation;
    }

    public static void addRealizedInformation(DataType dataType, TraceableElement elt) {
        if (dataType != null && elt != null) {
            InformationRealization realization = InformationFactory.eINSTANCE.createInformationRealization();
            dataType.getOwnedInformationRealizations().add((Object)realization);
            realization.setTargetElement(elt);
        }
    }

    public static void removeRealizedInformation(DataType dataType, TraceableElement elt) {
        if (dataType != null && elt != null) {
            InformationRealization realization = null;
            ListIterator it = dataType.getOwnedInformationRealizations().listIterator();
            while (it.hasNext()) {
                InformationRealization gen = (InformationRealization)it.next();
                if (!gen.getTargetElement().equals(elt)) continue;
                realization = gen;
            }
            if (realization != null) {
                dataType.getOwnedInformationRealizations().remove(realization);
                realization.destroy();
            }
        }
    }
}

