/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.la.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.helpers.fa.delegates.AbstractFunctionHelper;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.pa.PhysicalFunction;

public class LogicalFunctionHelper {
    private static LogicalFunctionHelper instance;

    private LogicalFunctionHelper() {
    }

    public static LogicalFunctionHelper getInstance() {
        if (instance == null) {
            instance = new LogicalFunctionHelper();
        }
        return instance;
    }

    public Object doSwitch(LogicalFunction element, EStructuralFeature feature) {
        List<SystemFunction> ret = null;
        if (feature.equals(LaPackage.Literals.LOGICAL_FUNCTION__ALLOCATOR_LOGICAL_ACTORS)) {
            ret = this.getAllocatorLogicalActors(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_FUNCTION__ALLOCATOR_LOGICAL_COMPONENTS)) {
            ret = this.getAllocatorLogicalComponents(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_FUNCTION__REALIZED_SYSTEM_FUNCTIONS)) {
            ret = this.getRealizedSystemFunctions(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_FUNCTION__REALIZING_PHYSICAL_FUNCTIONS)) {
            ret = this.getRealizingPhysicalFunctions(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_FUNCTION__CONTAINED_LOGICAL_FUNCTIONS)) {
            ret = this.getContainedLogicalFunctions(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_FUNCTION__CHILDREN_LOGICAL_FUNCTIONS)) {
            ret = this.getChildrenLogicalFunctions(element);
        }
        if (ret == null) {
            ret = AbstractFunctionHelper.getInstance().doSwitch((AbstractFunction)element, feature);
        }
        return ret;
    }

    protected List<LogicalActor> getAllocatorLogicalActors(LogicalFunction element) {
        ArrayList<LogicalActor> ret = new ArrayList<LogicalActor>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement src;
            if (!(trace instanceof ComponentFunctionalAllocation) || !((src = trace.getSourceElement()) instanceof LogicalActor)) continue;
            ret.add((LogicalActor)src);
        }
        return ret;
    }

    protected List<LogicalComponent> getAllocatorLogicalComponents(LogicalFunction element) {
        ArrayList<LogicalComponent> ret = new ArrayList<LogicalComponent>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement src;
            if (!(trace instanceof ComponentFunctionalAllocation) || !((src = trace.getSourceElement()) instanceof LogicalComponent)) continue;
            ret.add((LogicalComponent)src);
        }
        return ret;
    }

    protected List<SystemFunction> getRealizedSystemFunctions(LogicalFunction element) {
        ArrayList<SystemFunction> ret = new ArrayList<SystemFunction>();
        for (FunctionRealization functionRealization : element.getOutFunctionRealizations()) {
            AbstractFunction abstractFunction = functionRealization.getAllocatedFunction();
            if (!(abstractFunction instanceof SystemFunction)) continue;
            ret.add((SystemFunction)abstractFunction);
        }
        return ret;
    }

    protected List<PhysicalFunction> getRealizingPhysicalFunctions(LogicalFunction element) {
        ArrayList<PhysicalFunction> ret = new ArrayList<PhysicalFunction>();
        for (FunctionRealization functionRealization : element.getInFunctionRealizations()) {
            AbstractFunction abstractFunction = functionRealization.getAllocatingFunction();
            if (!(abstractFunction instanceof PhysicalFunction)) continue;
            ret.add((PhysicalFunction)abstractFunction);
        }
        return ret;
    }

    protected List<LogicalFunction> getContainedLogicalFunctions(LogicalFunction element) {
        ArrayList<LogicalFunction> ret = new ArrayList<LogicalFunction>();
        for (AbstractFunction function : element.getOwnedFunctions()) {
            if (!(function instanceof LogicalFunction)) continue;
            ret.add((LogicalFunction)function);
        }
        return ret;
    }

    protected List<LogicalFunction> getChildrenLogicalFunctions(LogicalFunction element) {
        ArrayList<LogicalFunction> ret = new ArrayList<LogicalFunction>();
        for (AbstractFunction function : element.getSubFunctions()) {
            if (!(function instanceof LogicalFunction)) continue;
            ret.add((LogicalFunction)function);
        }
        return ret;
    }
}

