/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.menu.dynamic;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractNavigatorAction
extends Action {
    private ISelectionProvider _provider;
    private Shell _shell;

    protected AbstractNavigatorAction(ISelectionProvider selectionProvider) {
        this._provider = selectionProvider;
    }

    protected AbstractNavigatorAction(Shell shell, ISelectionProvider selectionProvider) {
        this(selectionProvider);
        this._shell = shell;
    }

    protected Object getSelection(Class<?> objectType) {
        Object selectedObject = null;
        IStructuredSelection selectedObjects = (IStructuredSelection)this._provider.getSelection();
        if (!selectedObjects.isEmpty()) {
            Object firstElement = selectedObjects.getFirstElement();
            if (selectedObjects.size() == 1 && objectType.isInstance(firstElement)) {
                selectedObject = firstElement;
            }
        }
        return selectedObject;
    }

    protected Shell getShell() {
        return this._shell;
    }

    public boolean isSelectionCompatible() {
        boolean isEnabled = false;
        Object element = this.getSelection(this.getModelElementClass());
        if (element != null) {
            this.setSelectedElement(element);
            isEnabled = true;
        }
        return isEnabled;
    }

    protected abstract Class<?> getModelElementClass();

    protected abstract void setSelectedElement(Object var1);

    protected ISharedImages getSharedImages() {
        return PlatformUI.getWorkbench().getSharedImages();
    }

    protected ISelectionProvider getSelectionProvider() {
        return this._provider;
    }
}

