/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.menu.dynamic;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.jface.viewers.ISelection;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.menu.dynamic.CreationHelper;
import org.polarsys.capella.common.menu.dynamic.contributions.ActionContributionProvider;
import org.polarsys.capella.common.menu.dynamic.contributions.IMDEMenuItemContribution;

public class DynamicCreateChildAction
extends CreateChildAction {
    public DynamicCreateChildAction(EditingDomain editingDomain, ISelection selection, Object descriptor) {
        super(null, selection, descriptor);
        this.editingDomain = editingDomain;
    }

    public boolean isEnabled() {
        boolean selection = true;
        EObject owner = this.getOwner();
        EClass objectClass = ((EObject)((CommandParameter)this.descriptor).getValue()).eClass();
        EStructuralFeature feature = this.getFeature();
        for (IMDEMenuItemContribution contribution : ActionContributionProvider.getInstance().getAllActionContributions(objectClass)) {
            if (!(selection &= contribution.selectionContribution((ModelElement)owner, objectClass, feature))) break;
        }
        return selection;
    }

    public boolean isExecutable() {
        boolean result = false;
        if (this.command == null) {
            return result;
        }
        if (this.command instanceof CreateChildCommand) {
            CreateChildCommand childCommand = (CreateChildCommand)this.command;
            result = childCommand.getCommand() != UnexecutableCommand.INSTANCE;
        }
        return result;
    }

    public void run() {
        final Command basicCreationCmd = this.command;
        CompoundCommand cmd = new CompoundCommand();
        cmd.append(basicCreationCmd);
        cmd.setLabel(basicCreationCmd.getLabel());
        cmd.setDescription(basicCreationCmd.getDescription());
        CommandWrapper additionalCommand = new CommandWrapper(){

            public Command createCommand() {
                StrictCompoundCommand scc;
                Object createdElement;
                Collection collection = basicCreationCmd.getResult();
                if (collection.size() == 1 && (createdElement = collection.iterator().next()) instanceof AbstractNamedElement && (scc = CreationHelper.getAdditionnalCommand(DynamicCreateChildAction.this.editingDomain, (ModelElement)((AbstractNamedElement)createdElement), DynamicCreateChildAction.this.getOwner(), ((EObject)((CommandParameter)DynamicCreateChildAction.this.descriptor).getValue()).eClass(), DynamicCreateChildAction.this.getFeature())) != null) {
                    return scc;
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)additionalCommand);
        this.editingDomain.getCommandStack().execute((Command)cmd);
    }

    protected EObject getOwner() {
        EObject owner = null;
        Command cmd = ((CreateChildCommand)this.command).getCommand();
        if (cmd instanceof AddCommand) {
            owner = ((AddCommand)cmd).getOwner();
        } else if (cmd instanceof SetCommand) {
            owner = ((SetCommand)cmd).getOwner();
        }
        return owner;
    }

    protected EStructuralFeature getFeature() {
        EStructuralFeature feature = null;
        Command cmd = ((CreateChildCommand)this.command).getCommand();
        if (cmd instanceof AddCommand) {
            feature = ((AddCommand)cmd).getFeature();
        } else if (cmd instanceof SetCommand) {
            feature = ((SetCommand)cmd).getFeature();
        }
        return feature;
    }
}

