/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common.handlers.transformation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.handlers.ISelectionContext;
import org.polarsys.capella.core.projection.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.projection.common.handlers.transformation.ITransformationHandler;
import org.polarsys.capella.core.projection.common.rules.IRuleTransformation;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.ITransfoRule;
import org.polarsys.capella.core.tiger.TransfoException;
import org.polarsys.capella.core.tiger.helpers.Query;

public class TigerTransformationHandler
implements ITransformationHandler {
    @Override
    public IStatus isOrWillBeTransformed(EObject element_p, IContext context_p) {
        ITransfo transfo_p = context_p.getTransfo();
        boolean result = false;
        if (element_p != null) {
            result = Query.isElementTransformed((EObject)element_p, (ITransfo)transfo_p);
            try {
                EClass clazz;
                ITransfoRule ruleSource = transfo_p.findCachedMatchingRule(element_p);
                if (ruleSource != null && ruleSource instanceof IRuleTransformation && (clazz = this.getTargetType(element_p, context_p)) != null) {
                    result |= ((IRuleTransformation)ruleSource).transformRequired(element_p, context_p).isOK();
                }
            }
            catch (TransfoException transfoException) {
                // empty catch block
            }
        }
        if (result) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    @Override
    public IStatus isOrWillBeTransformedTo(EObject element_p, IContext context_p, EClass target) {
        ITransfo transfo_p = context_p.getTransfo();
        if (element_p != null) {
            if (Query.retrieveTransformedElement((EObject)element_p, (ITransfo)transfo_p, (EClass)target) != null) {
                return Status.OK_STATUS;
            }
            try {
                ITransfoRule ruleSource = transfo_p.findCachedMatchingRule(element_p);
                if (ruleSource != null && ruleSource instanceof IRuleTransformation && EcoreUtil2.isEqualOrSuperClass((EClass)target, (EClass)ruleSource.getTargetType())) {
                    return ((IRuleTransformation)ruleSource).transformRequired(element_p, context_p);
                }
            }
            catch (TransfoException transfoException) {
                // empty catch block
            }
        }
        return Status.CANCEL_STATUS;
    }

    @Override
    public void init(IContext context_p) {
    }

    @Override
    public void dispose(IContext context_p) {
    }

    @Override
    public EObject getBestTracedElement(EObject source_p, IContext context_p) {
        final EClass targetType = this.getTargetType(source_p, context_p);
        ISelectionContext context = new ISelectionContext(){

            @Override
            public boolean match(EObject matchSource_p, EObject matchTarget_p, IContext matchContext_p) {
                return targetType == null || targetType.isInstance((Object)matchTarget_p);
            }
        };
        return this.getBestTracedElement(source_p, context_p, context);
    }

    @Override
    public EObject getBestTracedElement(EObject source_p, IContext context_p, final EClass class_p) {
        ISelectionContext context = new ISelectionContext(){

            @Override
            public boolean match(EObject matchSource_p, EObject matchTarget_p, IContext matchContext_p) {
                return class_p == null || class_p.isInstance((Object)matchTarget_p);
            }
        };
        return this.getBestTracedElement(source_p, context_p, context);
    }

    public EObject getBestTracedElement(EObject source_p, IContext context_p, ISelectionContext sContext_p) {
        for (EObject target : TraceabilityHandlerHelper.getInstance(context_p).retrieveTracedElements(source_p, context_p)) {
            if (sContext_p != null && !sContext_p.match(source_p, target, context_p)) continue;
            return target;
        }
        return null;
    }

    @Override
    public EClass getTargetType(EObject element_p, IContext context_p) {
        ITransfo transfo_p = context_p.getTransfo();
        if (element_p != null) {
            try {
                ITransfoRule ruleSource = transfo_p.findCachedMatchingRule(element_p);
                if (ruleSource != null) {
                    return ruleSource.getTargetType();
                }
            }
            catch (TransfoException transfoException) {
                // empty catch block
            }
        }
        return null;
    }
}

