/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.libraries.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.ef.domain.IEditingDomainListener;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.IModelIdentifier;
import org.polarsys.capella.common.libraries.provider.ILibraryProvider;
import org.polarsys.capella.common.libraries.provider.ILibraryProviderListener;

public class LibraryManager
extends ILibraryManager
implements ILibraryProviderListener,
IEditingDomainListener {
    private static final String PROVIDER_EXTENSION = "org.polarsys.capella.common.libraries.providers";
    Collection<ILibraryProvider> _providers = null;
    Collection<IModelIdentifier> _models = null;
    HashMap<TransactionalEditingDomain, IModel> _modelsPerDomain = null;

    public Collection<ILibraryProvider> getProviders() {
        if (this._providers == null) {
            this._providers = new HashSet<ILibraryProvider>();
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(PROVIDER_EXTENSION);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    ILibraryProvider provider = (ILibraryProvider)element.createExecutableExtension("class");
                    if (provider != null) {
                        this._providers.add(provider);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            for (ILibraryProvider provider : this._providers) {
                provider.addListener(this);
            }
        }
        return this._providers;
    }

    @Override
    public Collection<IModelIdentifier> getAvailableModels() {
        if (this._models == null) {
            this._models = new ArrayList<IModelIdentifier>();
            for (ILibraryProvider provider : this.getProviders()) {
                for (IModelIdentifier model : provider.getAvailableModels()) {
                    if (this._models.contains(model)) continue;
                    this._models.add(model);
                }
            }
        }
        return this._models;
    }

    @Override
    public void onLibraryProviderChanged(ILibraryProviderListener.LibraryProviderEvent event) {
        this._models = null;
        this._modelsPerDomain = null;
    }

    @Override
    public Collection<IModel> getAllModels(TransactionalEditingDomain domain) {
        HashMap<IModelIdentifier, IModel> models = new HashMap<IModelIdentifier, IModel>();
        for (IModelIdentifier identifier : this.getAvailableModels()) {
            IModel model = this.getModel(domain, identifier);
            if (model == null) continue;
            models.put(identifier, model);
        }
        return models.values();
    }

    @Override
    public IModel getModel(TransactionalEditingDomain domain, IModelIdentifier identifier) {
        if (identifier != null) {
            for (ILibraryProvider provider : this.getProviders()) {
                IModel model = provider.getModelDefinition(identifier, domain);
                if (model == null) continue;
                return model;
            }
        }
        return null;
    }

    @Override
    public IModel getModel(EObject object) {
        for (ILibraryProvider provider : this.getProviders()) {
            IModel model = provider.getModel(object);
            if (model == null) continue;
            return model;
        }
        return null;
    }

    @Override
    public IModel getModel(TransactionalEditingDomain domain) {
        if (this._modelsPerDomain != null && this._modelsPerDomain.containsKey(domain)) {
            return this._modelsPerDomain.get(domain);
        }
        for (ILibraryProvider provider : this.getProviders()) {
            IModel model = provider.getModel(domain);
            if (model == null) continue;
            if (this._modelsPerDomain == null) {
                this._modelsPerDomain = new HashMap();
            }
            this._modelsPerDomain.put(domain, model);
            return model;
        }
        return null;
    }

    @Override
    public IModelIdentifier getModelIdentifier(URI semanticUri) {
        for (ILibraryProvider provider : this.getProviders()) {
            IModelIdentifier model = provider.getModelIdentifier(semanticUri);
            if (model == null) continue;
            return model;
        }
        return null;
    }

    public void createdEditingDomain(EditingDomain editingDomain) {
    }

    public void disposedEditingDomain(EditingDomain editingDomain) {
        if (this._modelsPerDomain != null) {
            this._modelsPerDomain.remove(editingDomain);
        }
    }
}

