/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.connection;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_Connection_FunctionalExchangeAllocation
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ComponentExchange && !(eObj instanceof PhysicalLink)) {
            ComponentExchange ce = (ComponentExchange)eObj;
            EList functionalExchanges = ce.getAllocatedFunctionalExchanges();
            BlockArchitecture ceLevel = MDCHK_Connection_FunctionalExchangeAllocation.getArchitectureLevel((CapellaElement)ce);
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            for (FunctionalExchange fe : functionalExchanges) {
                BlockArchitecture feLevel = MDCHK_Connection_FunctionalExchangeAllocation.getArchitectureLevel((CapellaElement)fe);
                if (ceLevel == null || feLevel == null || feLevel == ceLevel) continue;
                statuses.add(ctx.createFailureStatus(new Object[]{ce.getName(), ce.eClass().getName(), ceLevel.getName(), fe.getName(), fe.eClass().getName(), feLevel.getName()}));
            }
            if (statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
            }
        }
        return ctx.createSuccessStatus();
    }

    private static BlockArchitecture getArchitectureLevel(CapellaElement element) {
        BlockArchitecture returnvalue = null;
        EObject container = element.eContainer();
        if (container != null) {
            while (!(container instanceof BlockArchitecture) && container != null) {
                container = container.eContainer();
            }
            if (container instanceof BlockArchitecture) {
                returnvalue = (BlockArchitecture)container;
            }
        }
        return returnvalue;
    }
}

