/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.diagram.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.core.diagram.helpers.naming.DiagramNamingConstants;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.sirius.analysis.ABServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.transition.diagram.handlers.AbstractDiagramHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ArchitectureHandler
extends AbstractDiagramHandler {
    @Override
    public boolean handles(IContext context_p, RepresentationDescription representation_p) {
        if (DiagramHelper.getService().isA(representation_p, "Operational Entity Blank")) {
            return true;
        }
        if (DiagramHelper.getService().isA(representation_p, "System Architecture Blank")) {
            return true;
        }
        if (DiagramHelper.getService().isA(representation_p, "Logical Architecture Blank")) {
            return true;
        }
        return DiagramHelper.getService().isA(representation_p, "Physical Architecture Blank");
    }

    @Override
    public DSemanticDecorator showNode(IContext context_p, RepresentationDescription sourceDescription_p, DDiagramContents targetContents_p, AbstractNodeMapping mapping_p, DSemanticDecorator containerNode_p, EObject targetSemantic_p) {
        if (targetSemantic_p instanceof Part && ((Part)targetSemantic_p).getAbstractType() instanceof Component && BlockArchitectureExt.getFirstComponent((ModellingArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)targetSemantic_p)).equals(((Part)targetSemantic_p).getAbstractType())) {
            return null;
        }
        return super.showNode(context_p, sourceDescription_p, targetContents_p, mapping_p, containerNode_p, targetSemantic_p);
    }

    @Override
    public boolean covers(IContext context_p, RepresentationDescription description_p) {
        if (DiagramHelper.getService().isA(description_p, "Operational Entity Blank")) {
            return true;
        }
        if (DiagramHelper.getService().isA(description_p, "System Architecture Blank")) {
            return true;
        }
        return DiagramHelper.getService().isA(description_p, "Logical Architecture Blank");
    }

    @Override
    public boolean backCovers(IContext context_p, RepresentationDescription description_p) {
        if (DiagramHelper.getService().isA(description_p, "System Architecture Blank")) {
            return true;
        }
        if (DiagramHelper.getService().isA(description_p, "Logical Architecture Blank")) {
            return true;
        }
        return DiagramHelper.getService().isA(description_p, "Physical Architecture Blank");
    }

    @Override
    public EObject _getTargetSemantic(IContext context_p, EObject sourceSemantic_p, RepresentationDescription sourceDescription_p, RepresentationDescription targetDescription_p) {
        EObject result = super._getTargetSemantic(context_p, sourceSemantic_p, sourceDescription_p, targetDescription_p);
        if (sourceSemantic_p instanceof Entity) {
            result = null;
        }
        return result;
    }

    @Override
    public Collection<EObject> getTargetSemantics(IContext context_p, EObject sourceSemantic_p, RepresentationDescription sourceDescription_p, RepresentationDescription targetDescription_p) {
        Collection<EObject> result = super.getTargetSemantics(context_p, sourceSemantic_p, sourceDescription_p, targetDescription_p);
        if (sourceSemantic_p instanceof Entity) {
            ArrayList<EObject> result2 = new ArrayList<EObject>();
            for (EObject traced : result) {
                Iterator iterator;
                if (!(traced instanceof Component) || !(iterator = ComponentExt.getRepresentingParts((Component)((Component)traced)).iterator()).hasNext()) continue;
                Part part = (Part)iterator.next();
                result2.add((EObject)part);
            }
            return result2;
        }
        return result;
    }

    @Override
    public DDiagramElement showEdge(IContext context_p, RepresentationDescription sourceDescription_p, DDiagramContents targetContents_p, EdgeMapping mapping_p, DSemanticDecorator sourceNode_p, DSemanticDecorator targetNode_p, EObject targetSemantic_p) {
        if (DiagramHelper.getService().isA(sourceDescription_p, "Operational Entity Blank")) {
            if (targetSemantic_p instanceof FunctionalExchange) {
                ABServices.getService().showABFunctionalExchange(Collections.singleton(targetSemantic_p), targetContents_p);
            } else if (targetSemantic_p instanceof ComponentExchange) {
                ABServices.getService().showABComponentExchange(Collections.singleton(targetSemantic_p), targetContents_p);
            }
        }
        return super.showEdge(context_p, sourceDescription_p, targetContents_p, mapping_p, sourceNode_p, targetNode_p, targetSemantic_p);
    }

    @Override
    public DiagramElementMapping getTargetMapping(IContext context_p, RepresentationDescription sourceDescription_p, RepresentationDescription targetDescription_p, DiagramElementMapping sourceMapping_p, EObject source_p, EObject target_p) {
        String mappingName = sourceMapping_p.getName();
        String targetMappingName = null;
        if (DiagramHelper.getService().isA(sourceDescription_p, "Operational Entity Blank")) {
            if (DiagramHelper.getService().isA(targetDescription_p, "System Architecture Blank")) {
                if ("OAB_OperationalProcessEnd".equals(mappingName)) {
                    targetMappingName = "CA_FunctionalChainEnd";
                } else if ("OAB_CommunicationMean".equals(mappingName)) {
                    targetMappingName = "CA Data Flow Between Actors and System";
                } else if ("OAB_ComponentCategory".equals(mappingName)) {
                    targetMappingName = "SAB_ComponentCategory";
                } else if ("OAB_ComponentCategory_Pin".equals(mappingName)) {
                    targetMappingName = "SAB_ComponentCategory_Pin";
                } else if ("OAB_Entity1".equals(mappingName)) {
                    targetMappingName = "System System";
                    if (target_p instanceof AbstractActor) {
                        targetMappingName = "System Actors";
                    }
                    if (target_p instanceof Part && ((Part)target_p).getAbstractType() != null && ((Part)target_p).getAbstractType() instanceof AbstractActor) {
                        targetMappingName = "System Actors";
                    }
                } else if ("OAB Interaction".equals(mappingName)) {
                    targetMappingName = "CA DataFlow between Function";
                } else if ("OAB_Activity".equals(mappingName)) {
                    targetMappingName = "CA System Function";
                }
            }
        } else if (DiagramHelper.getService().isA(sourceDescription_p, "System Architecture Blank")) {
            if (DiagramHelper.getService().isA(targetDescription_p, "Logical Architecture Blank")) {
                if ("System Actors".equals(mappingName)) {
                    targetMappingName = "Logical Actors";
                } else if ("SAB_ComponentCategory".equals(mappingName)) {
                    targetMappingName = "LAB_ComponentCategory";
                } else if ("SAB_ComponentCategory_Pin".equals(mappingName)) {
                    targetMappingName = "LAB_ComponentCategory_Pin";
                } else if ("CA Component Port".equals(mappingName)) {
                    targetMappingName = "LAB ComponentPort";
                } else if ("CA Data Flow Between Actors and System".equals(mappingName)) {
                    targetMappingName = "LAB DataFlow between Logical Components";
                } else if ("CA System Node".equals(mappingName)) {
                    targetMappingName = "LAB Sub Node";
                } else if ("CA_InputPin by Categorie".equals(mappingName)) {
                    targetMappingName = "LAB InputPin by Categorie";
                } else if ("CA DataFlow by Categorie".equals(mappingName)) {
                    targetMappingName = "LAB DataFlow by Categorie";
                } else if ("CA_OutputPin by Categorie".equals(mappingName)) {
                    targetMappingName = "LAB OutputPin by Categorie";
                } else if ("CA Flow Port on System Function".equals(mappingName)) {
                    targetMappingName = "LAB Flow Port on Logical Function";
                } else if ("SAB_PhysicalPort".equals(mappingName)) {
                    targetMappingName = "LAB_PhysicalPort";
                } else if ("SAB_PhysicalLink".equals(mappingName)) {
                    targetMappingName = "LAB_PhysicalLink";
                } else if ("CA PortRealization FunctionPort to ComponentPort".equals(mappingName)) {
                    targetMappingName = "LAB PortRealization FlowPort to ComponentPort";
                } else if ("CA_FunctionalChainEnd".equals(mappingName)) {
                    targetMappingName = "LAB_FunctionalChainEnd";
                } else if ("CA_FunctionalChain".equals(mappingName)) {
                    targetMappingName = "LAB_FunctionalChain";
                } else if ("SAB_InternPhysicalPathLink".equals(mappingName)) {
                    targetMappingName = "LAB_InternPhysicalPathLink";
                } else if ("SAB_PhysicalPathEnd".equals(mappingName)) {
                    targetMappingName = "LAB_PhysicalPathEnd";
                } else if ("CA DataFlow between Function".equals(mappingName)) {
                    targetMappingName = "LAB DataFlow between Function";
                } else if ("CA_InternLink".equals(mappingName)) {
                    targetMappingName = "LAB_InternLink";
                } else if ("CA System Function".equals(mappingName)) {
                    targetMappingName = "LAB Logical Function";
                } else if ("System System".equals(mappingName)) {
                    targetMappingName = "LAB Logical Component";
                }
            }
        } else if (DiagramHelper.getService().isA(sourceDescription_p, "Logical Architecture Blank") && DiagramHelper.getService().isA(targetDescription_p, "Physical Architecture Blank")) {
            if ("LAB_ComponentCategory".equals(mappingName)) {
                targetMappingName = "PAB_ComponentCategory";
            } else if ("LAB_ComponentCategory_Pin".equals(mappingName)) {
                targetMappingName = "PAB_ComponentCategory_Pin";
            } else if ("LAB ComponentPort".equals(mappingName)) {
                targetMappingName = "PAB_Port";
            } else if ("LAB DataFlow between Logical Components".equals(mappingName)) {
                targetMappingName = "PAB_Exchange";
            } else if ("LAB PortRealization FlowPort to ComponentPort".equals(mappingName)) {
                targetMappingName = "PAB PortRealization";
            } else if ("LAB Sub Node".equals(mappingName)) {
                targetMappingName = "PAB_ControlFunction";
            } else if ("LAB InputPin by Categorie".equals(mappingName)) {
                targetMappingName = "PAB InputPin by Categorie";
            } else if ("LAB DataFlow by Categorie".equals(mappingName)) {
                targetMappingName = "PAB_FunctionExchange by Categorie";
            } else if ("LAB OutputPin by Categorie".equals(mappingName)) {
                targetMappingName = "PAB OutputPin by Categorie";
            } else if ("LAB Flow Port on Logical Function".equals(mappingName)) {
                targetMappingName = "PAB_Pin";
            } else if ("LAB_FunctionalChainEnd".equals(mappingName)) {
                targetMappingName = "PAB_FunctionalChainEnd";
            } else if ("LAB_FunctionalChain".equals(mappingName)) {
                targetMappingName = "PAB_FunctionalChain";
            } else if ("LAB_PhysicalPathEnd".equals(mappingName)) {
                targetMappingName = "PAB_PhysicalPathEnd";
            } else if ("LAB_PhysicalLink".equals(mappingName)) {
                targetMappingName = "PAB_PhysicalLink";
            } else if ("LAB_InternLink".equals(mappingName)) {
                targetMappingName = "PAB_InternLink";
            } else if ("LAB DataFlow between Function".equals(mappingName)) {
                targetMappingName = "PAB_FunctionExchange";
            } else if ("LAB_InternLink".equals(mappingName)) {
                targetMappingName = "PAB_InternLink";
            } else if ("Logical Actors".equals(mappingName)) {
                targetMappingName = "PAB_Actor";
            } else if ("LAB Logical Component".equals(mappingName)) {
                targetMappingName = "PAB_PC";
            } else if ("LAB Logical Function".equals(mappingName)) {
                targetMappingName = "PAB_PhysicalFunction";
            } else if ("LAB_PhysicalPort".equals(mappingName)) {
                targetMappingName = "PAB_Port";
            }
        }
        return DiagramServices.getDiagramServices().getMappingByName(targetDescription_p, targetMappingName);
    }

    @Override
    public RepresentationDescription getTargetDescription(IContext context_p, Session session_p, RepresentationDescription description_p) {
        DiagramHelper service = DiagramHelper.getService();
        if (service.isA(description_p, "Operational Entity Blank")) {
            return service.getDescription(session_p, "System Architecture Blank");
        }
        if (service.isA(description_p, "System Architecture Blank")) {
            return service.getDescription(session_p, "Logical Architecture Blank");
        }
        if (service.isA(description_p, "Logical Architecture Blank")) {
            return service.getDescription(session_p, "Physical Architecture Blank");
        }
        return null;
    }

    @Override
    public String getTargetName(IContext context_p, DRepresentation diagram_p, RepresentationDescription targetDescription_p) {
        RepresentationDescription description = DiagramHelper.getService().getDescription(diagram_p);
        String name = diagram_p.getName();
        name = name.replace(description.getName(), targetDescription_p.getName());
        if (DiagramHelper.getService().isA(description, "Operational Entity Blank")) {
            if (DiagramHelper.getService().isA(targetDescription_p, "System Architecture Blank")) {
                name = name.replace(description.getLabel(), targetDescription_p.getName());
                name = name.replace(DiagramNamingConstants.OPERATIONAL_ENTITY_BLANK_DIAGRAM_PREFIX, DiagramNamingConstants.SYSTEM_ARCHITECTURE_BLANK_DIAGRAM_PREFIX);
            }
        } else if (DiagramHelper.getService().isA(description, "System Architecture Blank")) {
            if (DiagramHelper.getService().isA(targetDescription_p, "Logical Architecture Blank")) {
                name = name.replace(DiagramNamingConstants.SYSTEM_ARCHITECTURE_BLANK_DIAGRAM_PREFIX, DiagramNamingConstants.LOGICAL_ARCHITECTURE_BLANK_DIAGRAM_PREFIX);
            }
        } else if (DiagramHelper.getService().isA(description, "Logical Architecture Blank") && DiagramHelper.getService().isA(targetDescription_p, "Physical Architecture Blank")) {
            name = name.replace(DiagramNamingConstants.LOGICAL_ARCHITECTURE_BLANK_DIAGRAM_PREFIX, DiagramNamingConstants.PHYSICAL_ARCHITECTURE_BLANK_DIAGRAM_PREFIX);
        }
        return name;
    }

    @Override
    public boolean isReconciliable(IContext context_p, RepresentationDescription sourceDescription_p, DEdge edgeTarget_p, DSemanticDecorator sourceNode_p, DSemanticDecorator targetNode_p) {
        if (DiagramHelper.getService().isA(sourceDescription_p, "Operational Entity Blank")) {
            if (edgeTarget_p.getTarget() instanceof FunctionalExchange) {
                return EcoreUtil.isAncestor((EObject)sourceNode_p, (EObject)edgeTarget_p.getSourceNode()) && EcoreUtil.isAncestor((EObject)targetNode_p, (EObject)edgeTarget_p.getTargetNode());
            }
            if (edgeTarget_p.getTarget() instanceof ComponentExchange) {
                return EcoreUtil.isAncestor((EObject)sourceNode_p, (EObject)edgeTarget_p.getSourceNode()) && EcoreUtil.isAncestor((EObject)targetNode_p, (EObject)edgeTarget_p.getTargetNode());
            }
        }
        return sourceNode_p.equals(edgeTarget_p.getSourceNode()) && targetNode_p.equals(edgeTarget_p.getTargetNode());
    }

    @Override
    public EObject getTargetDefaultLocation(IContext context_p, BlockArchitecture root_p, RepresentationDescription description_p) {
        if (DiagramHelper.getService().isA(description_p, "Operational Entity Blank")) {
            return BlockArchitectureExt.getContext((BlockArchitecture)root_p);
        }
        if (DiagramHelper.getService().isA(description_p, "System Architecture Blank")) {
            return BlockArchitectureExt.getFirstComponent((ModellingArchitecture)root_p);
        }
        if (DiagramHelper.getService().isA(description_p, "Logical Architecture Blank")) {
            return BlockArchitectureExt.getFirstComponent((ModellingArchitecture)root_p);
        }
        if (DiagramHelper.getService().isA(description_p, "Physical Architecture Blank")) {
            return BlockArchitectureExt.getFirstComponent((ModellingArchitecture)root_p);
        }
        return null;
    }
}

