/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.diagram.helpers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.core.diagram.helpers.traceability.IDiagramTraceability;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.common.context.TransitionContext;
import org.polarsys.capella.core.transition.diagram.handlers.DiagramDescriptionHelper;
import org.polarsys.capella.core.transition.diagram.handlers.IDiagramHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DiagramTransitionTraceability
implements IDiagramTraceability {
    public static final String allocating_diagrams = "INITIALIZATION_REALIZING";
    public static final String allocated_diagrams = "INITIALIZATION_REALIZED";
    private IContext context;

    protected IDiagramHandler getHandler() {
        return DiagramDescriptionHelper.getService(this.getContext());
    }

    protected IContext getContext() {
        if (this.context == null) {
            this.context = new TransitionContext();
        }
        return this.context;
    }

    public boolean isRealizingable(DRepresentation realizing) {
        IDiagramHandler handler = this.getHandler();
        RepresentationDescription sourceDescription = DiagramHelper.getService().getDescription(realizing);
        if (handler == null || sourceDescription == null) {
            return false;
        }
        if (!handler.backCovers(this.getContext(), sourceDescription)) {
            return false;
        }
        return handler.backCovers(this.getContext(), realizing);
    }

    public boolean isRealizable(DRepresentation realized, DRepresentation realizing) {
        Session session = DiagramHelper.getService().getSession(realized);
        IDiagramHandler handler = this.getHandler();
        RepresentationDescription sourceDescription = DiagramHelper.getService().getDescription(realized);
        RepresentationDescription targetDescription = DiagramHelper.getService().getDescription(realizing);
        if (sourceDescription == null || targetDescription == null) {
            return false;
        }
        if (!handler.covers(this.context, sourceDescription)) {
            return false;
        }
        if (!handler.covers(this.context, realized)) {
            return false;
        }
        if (!handler.backCovers(this.context, targetDescription)) {
            return false;
        }
        if (!handler.backCovers(this.context, realizing)) {
            return false;
        }
        RepresentationDescription target = this.getHandler().getTargetDescription(this.context, session, sourceDescription);
        if (target == null) {
            return false;
        }
        if (!target.equals(targetDescription)) {
            return false;
        }
        EObject sourceTarget = ((DSemanticDecorator)realized).getTarget();
        EObject targetTarget = ((DSemanticDecorator)realizing).getTarget();
        if (sourceTarget == null || targetTarget == null) {
            return false;
        }
        BlockArchitecture sourceArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)sourceTarget);
        BlockArchitecture targetArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)targetTarget);
        if (sourceArchitecture == null || targetArchitecture == null) {
            return false;
        }
        return sourceArchitecture.getAllocatingArchitectures().contains((Object)targetArchitecture);
    }

    public Collection<DRepresentation> getRealizingRepresentations(DRepresentation representation) {
        return this.getDiagrams(representation, allocating_diagrams);
    }

    public Collection<DRepresentation> getRealizedRepresentations(DRepresentation representation) {
        return this.getDiagrams(representation, allocated_diagrams);
    }

    protected Collection<DRepresentation> getDiagrams(DRepresentation representation, String annotationId) {
        ArrayList<DRepresentation> diagrams = new ArrayList<DRepresentation>();
        DAnnotation annotation = RepresentationHelper.getAnnotation((String)annotationId, (DRepresentation)representation);
        if (annotation == null) {
            return diagrams;
        }
        Session session = DiagramHelper.getService().getSession(representation);
        if (session != null) {
            for (Resource resource : session.getAllSessionResources()) {
                if (annotation.getDetails() == null) continue;
                for (String value : annotation.getDetails().values()) {
                    try {
                        EObject element;
                        if (value == null || value.isEmpty() || (element = resource.getEObject(value)) == null || element.eIsProxy() || !(element instanceof DRepresentation) || diagrams.contains(element)) continue;
                        diagrams.add((DRepresentation)element);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return diagrams;
    }

    public IStatus addRealizingRepresentation(DRepresentation realized, DRepresentation realizing) {
        this.addAnnotation(realized, realizing, allocating_diagrams);
        this.addAnnotation(realizing, realized, allocated_diagrams);
        return Status.OK_STATUS;
    }

    protected IStatus addAnnotation(DRepresentation realized, DRepresentation realizing, String annotationId) {
        DAnnotation annotation = RepresentationHelper.getAnnotation((String)annotationId, (DRepresentation)realized);
        if (annotation == null) {
            annotation = RepresentationHelper.createAnnotation((String)annotationId, (DRepresentation)realized);
        }
        String id = realizing.eResource().getURIFragment((EObject)realizing);
        for (String value : annotation.getDetails().values()) {
            if (value == null || !value.equals(id)) continue;
            return Status.OK_STATUS;
        }
        annotation.getDetails().put((Object)("id_" + annotation.getDetails().size()), (Object)id);
        return Status.OK_STATUS;
    }

    public void dispose() {
        if (this.context != null) {
            this.context.reset();
            this.context = null;
        }
    }
}

