/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.AbstractApiTypeRoot;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Util;

public class DirectoryApiTypeContainer
extends ApiElement
implements IApiTypeContainer {
    private Map<String, String> fPackages;
    private String[] fPackageNames;

    public DirectoryApiTypeContainer(IApiElement parent, String location) {
        super(parent, 3, location);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        if (visitor.visit(this)) {
            this.init();
            packageNames = this.getPackageNames();
            i = 0;
            while (i < packageNames.length) {
                pkg = packageNames[i];
                if (visitor.visitPackage(pkg)) {
                    location = this.fPackages.get(pkg);
                    if (location != null && (dir = new File(location)).exists()) {
                        files = dir.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                return file.isFile() && file.getName().endsWith(".class");
                            }
                        });
                        if (files != null) {
                            classFiles = new ArrayList<LocalApiTypeRoot>();
                            j = 0;
                            while (j < files.length) {
                                name = files[j].getName();
                                typeName = name.substring(0, name.length() - 6);
                                if (pkg.length() > 0) {
                                    typeName = String.valueOf(pkg) + "." + typeName;
                                }
                                classFiles.add(new LocalApiTypeRoot(this, files[j].getAbsolutePath(), typeName));
                                ++j;
                            }
                            Collections.sort(classFiles);
                            for (IApiTypeRoot classFile : classFiles) {
                                visitor.visit(pkg, classFile);
                                visitor.end(pkg, classFile);
                            }
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 4 sources

                {
                    visitor.endVisitPackage(pkg);
                }
                ++i;
            }
        }
        visitor.end(this);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Directory Class File Container: " + this.getName());
        return buff.toString();
    }

    @Override
    public synchronized void close() throws CoreException {
        this.fPackages = null;
        this.fPackageNames = null;
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName) throws CoreException {
        File file;
        String location;
        this.init();
        int index = qualifiedName.lastIndexOf(46);
        String cfName = qualifiedName;
        String pkg = "";
        if (index > 0) {
            pkg = qualifiedName.substring(0, index);
            cfName = qualifiedName.substring(index + 1);
        }
        if ((location = this.fPackages.get(pkg)) != null && (file = new File(location, String.valueOf(cfName) + ".class")).exists()) {
            return new LocalApiTypeRoot(this, file.getAbsolutePath(), qualifiedName);
        }
        return null;
    }

    @Override
    public String[] getPackageNames() throws CoreException {
        this.init();
        if (this.fPackageNames == null) {
            ArrayList<String> names = new ArrayList<String>(this.fPackages.keySet());
            Object[] result = new String[names.size()];
            names.toArray(result);
            Arrays.sort(result);
            this.fPackageNames = result;
        }
        return this.fPackageNames;
    }

    private synchronized void init() {
        if (this.fPackages == null) {
            this.fPackages = new HashMap<String, String>();
            this.processDirectory("", new File(this.getName()));
        }
    }

    private void processDirectory(String packageName, File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            boolean hasClassFiles = false;
            ArrayList<File> dirs = new ArrayList<File>();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isDirectory()) {
                    dirs.add(file.getAbsoluteFile());
                } else if (!hasClassFiles && file.getName().endsWith(".class")) {
                    this.fPackages.put(packageName, dir.getAbsolutePath());
                    hasClassFiles = true;
                }
                ++i;
            }
            for (File child : dirs) {
                String nextName = null;
                nextName = packageName.length() == 0 ? child.getName() : String.valueOf(packageName) + "." + child.getName();
                this.processDirectory(nextName, child);
            }
        }
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName, String id) throws CoreException {
        return this.findTypeRoot(qualifiedName);
    }

    @Override
    public int getContainerType() {
        return 2;
    }

    static class LocalApiTypeRoot
    extends AbstractApiTypeRoot
    implements Comparable<Object> {
        String fLocation = null;

        public LocalApiTypeRoot(DirectoryApiTypeContainer directory, String location, String typeName) {
            super(directory, typeName);
            this.fLocation = location;
        }

        @Override
        public String getTypeName() {
            return this.getName();
        }

        @Override
        public int compareTo(Object o) {
            return this.getName().compareTo(((LocalApiTypeRoot)o).getName());
        }

        public boolean equals(Object obj) {
            if (obj instanceof LocalApiTypeRoot) {
                return ((LocalApiTypeRoot)obj).getName().equals(this.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        @Override
        public byte[] getContents() throws CoreException {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(new File(this.fLocation));
            }
            catch (FileNotFoundException e) {
                this.abort("File not found", e);
                return null;
            }
            try {
                byte[] byArray = Util.getInputStreamAsByteArray(stream, -1);
                return byArray;
            }
            catch (IOException ioe) {
                this.abort("Unable to read class file: " + this.getTypeName(), ioe);
                return null;
            }
            finally {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
    }
}

