/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.renderer;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.capella.common.flexibility.properties.schema.IEditableProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.wizards.schema.IPropertyRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;

public abstract class AbstractRenderer
implements IPropertyRenderer {
    private boolean disposed = true;

    @Override
    public void render(Composite parent, IRendererContext context) {
        this.performRender(parent, context);
        this.setDisposed(false);
        this.initialize(context.getProperty(this), context);
    }

    public void performRender(Composite parent, IRendererContext context) {
    }

    public void setDisposed(boolean disposed) {
        this.disposed = disposed;
    }

    protected boolean isDisposed() {
        return this.disposed;
    }

    protected ILabelProvider getLabelProvider(IRendererContext context) {
        return context.getLabelProvider();
    }

    @Override
    public void changeValue(IProperty property, IRendererContext context, Object newValue) {
        if (property instanceof IEditableProperty) {
            context.getPropertyContext().setCurrentValue(property, newValue);
        }
    }

    @Override
    public void updatedValue(IProperty property, IRendererContext propertyContext, Object newValue) {
    }

    @Override
    public void dispose(IRendererContext context) {
        this.setDisposed(true);
    }
}

